# Script for GET Foreign Key CONSTRAINT QUERY. 

if [[ $# != 1 ]]; then
	echo "Invalid arguments to get foreign keys." ;
	exit 12;
fi

# Loop through file containing schema names and extract routines for each of them
while read TABSCHEMA
do
     echo "Get all keys for schema $TABSCHEMA";
     fKeyFile="${TABSCHEMA}/""foreignKeys.dat";

db2 -x +o -r ${fKeyFile} "select "$ROWTAG", "$COLTAG"||A.CONSTNAME||"$ENDCOLTAG", "$COLTAG"||A.TABNAME||"$ENDCOLTAG", "$COLTAG"||A.TABSCHEMA||"$ENDCOLTAG", "$COLTAG"||A.REFKEYNAME||"$ENDCOLTAG", "$COLTAG"||A.REFTABSCHEMA||"$ENDCOLTAG", "$COLTAG"||A.REFTABNAME||"$ENDCOLTAG", 
        "$COLTAG"||B.COLNAME||"$ENDCOLTAG", "$COLTAG"||B.REFCOLNAME||"$ENDCOLTAG", "$COLTAG"||CHAR(B.COLSEQ)||"$ENDCOLTAG", "$COLTAG"||C.TYPE||"$ENDCOLTAG", "$COLTAG"||COALESCE(C.REMARKS, '')||"$ENDCOLTAG", "$ENDROWTAG" from 
 (SELECT * from SYSCAT.REFERENCES WHERE TABSCHEMA = '${TABSCHEMA}') A 
 JOIN  
  (SELECT X.CONSTNAME, X.COLNAME, X.TABNAME, X.TABSCHEMA, 
         Y.CONSTNAME REFCONSTNAME, Y.COLNAME REFCOLNAME, Y.TABNAME REFTABNAME, Y.TABSCHEMA REFTABSCHEMA, X.COLSEQ from 
     (SELECT * from SYSCAT.KEYCOLUSE WHERE TABSCHEMA = '${TABSCHEMA}') X 
     JOIN 
     (SELECT * from SYSCAT.KEYCOLUSE) Y 
     on (X.COLSEQ = Y.COLSEQ) 
  ) B  
 on (A.CONSTNAME = B.CONSTNAME and A.TABNAME = B.TABNAME and A.TABSCHEMA = B.TABSCHEMA 
      and A.REFKEYNAME = B.REFCONSTNAME and A.REFTABNAME = B.REFTABNAME and A.REFTABSCHEMA = B.REFTABSCHEMA), SYSCAT.TABCONST C 
 WHERE (A.CONSTNAME = C.CONSTNAME and A.TABNAME = C.TABNAME and A.TABSCHEMA = C.TABSCHEMA)";
done < $1

