<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:oja="http://xmlns.oracle.com/jdeveloper/1013/audit"
                xmlns="http://www.w3.org/1999/xhtml"
                exclude-result-prefixes="xsl oja">

  <xsl:output method="text"/>
  <!--
  - The character sequence to use when outputting a line break.
  -
  - Unlike XML document consumers, some text document consumers expect a
  - particular line terminator sequence. Audit generates the XML document
  - using the line terminator indicated in the JDeveloper environment options,
  - and sets this parameter to the same line terminator sequence so that a
  - and sets this parameter to te same line terminator sequence so that a
  - careful style sheet can ensure that the output file has consistent
  - line terminators.
  -->
  <xsl:param name="newline">
<xsl:text>
</xsl:text>
  </xsl:param>

  <xsl:template match="/">
    <xsl:text># Profile Report for </xsl:text>
    <xsl:value-of select="/oja:profile-report/oja:title"/><xsl:value-of select="$newline"/>
    <xsl:apply-templates>
      <xsl:sort select="/oja:rules/oja:rule/oja:category"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="/oja:profile-report/oja:profile">
    <xsl:text># Profile</xsl:text><xsl:value-of select="$newline"/>
    <xsl:text>Profile-Name:</xsl:text><xsl:value-of select="oja:name"/><xsl:value-of select="$newline"/>
    <xsl:choose>
      <xsl:when test="string-length(oja:key) &gt; 0">
        <xsl:text>Profile-Key:</xsl:text><xsl:value-of select="oja:key"/><xsl:value-of select="$newline"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text># Profile-Key:No Key Specified</xsl:text><xsl:value-of select="$newline"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>Profile-isDefault:</xsl:text><xsl:value-of select="oja:default"/><xsl:value-of select="$newline"/>
    <xsl:text>Profile-Url:</xsl:text><xsl:value-of select="oja:url"/><xsl:value-of select="$newline"/>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- RULES section -->
  <xsl:template match="/oja:profile-report/oja:rules">
    <xsl:text># Rules</xsl:text><xsl:value-of select="$newline"/>
    <xsl:for-each select="oja:rule">
      <xsl:call-template name="rule_assist"/>
    </xsl:for-each>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- Assists section -->
  <xsl:template match="/oja:profile-report/oja:assists">
    <xsl:text># Assists </xsl:text><xsl:value-of select="$newline"/>
    <xsl:for-each select="oja:assist">
      <xsl:call-template name="rule_assist"/>
    </xsl:for-each>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- rules and assists only vary by category so use the same template to process them -->
  <xsl:template name="rule_assist">
    <xsl:text># rule/assist - name/id - </xsl:text>
    <xsl:value-of select="oja:name"/><xsl:text>/</xsl:text>
    <xsl:value-of select="@id"/><xsl:value-of select="$newline"/>
    <xsl:text>rule-name:</xsl:text><xsl:value-of select="oja:name"/><xsl:value-of select="$newline"/>
    <xsl:text>rule-id:</xsl:text><xsl:value-of select="@id"/><xsl:value-of select="$newline"/>
    <xsl:text>rule-category:</xsl:text><xsl:value-of select="oja:category"/><xsl:value-of select="$newline"/>
    <xsl:choose>
      <xsl:when test="count(oja:rule-params/oja:rule-param) &gt; 0">
        <xsl:for-each select="oja:rule-params/oja:rule-param">
          <xsl:text>rule-param-name-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
          <xsl:value-of select="oja:param-name"/><xsl:value-of select="$newline"/>
          <xsl:text>rule-param-required-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
          <xsl:value-of select="oja:param-required"/><xsl:value-of select="$newline"/>
          <xsl:text>rule-param-type-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
          <xsl:value-of select="oja:param-type"/><xsl:value-of select="$newline"/>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text># rule-parameters: No Parameters specified</xsl:text><xsl:value-of select="$newline"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="string-length(oja:description) &gt; 0">
        <xsl:text>rule-description:</xsl:text><xsl:value-of select="oja:description"/><xsl:value-of select="$newline"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text># rule </xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text> has no description</xsl:text>
        <xsl:value-of select="$newline"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>rule-settings-style:</xsl:text><xsl:value-of select="oja:description"/><xsl:value-of select="$newline"/>
    <xsl:text>rule-settings-severity:</xsl:text><xsl:value-of select="oja:severity"/><xsl:value-of select="$newline"/>
    <xsl:text>rule-settings-enabled:</xsl:text><xsl:value-of select="@enabled"/><xsl:value-of select="$newline"/>
    <xsl:choose>
      <xsl:when test="count(oja:defaultTransform/oja:transform) &gt; 0">
        <xsl:for-each select="oja:defaultTransform/oja:transform">
          <xsl:text>rule-default-transform-name-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
          <xsl:value-of select="oja:name"/><xsl:value-of select="$newline"/>
          <xsl:if test="string-length(oja:description) &gt; 0">
            <xsl:text>rule-default-transform-description-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
            <xsl:value-of select="oja:description"/><xsl:value-of select="$newline"/>
          </xsl:if>
          <xsl:text>rule-default-transform-id-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
          <xsl:value-of select="@id"/><xsl:value-of select="$newline"/>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text># rule </xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text> has no default-transforms</xsl:text>
        <xsl:value-of select="$newline"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="count(oja:transforms/oja:transform) &gt; 0">
        <xsl:for-each select="oja:transforms/oja:transform">
          <xsl:text>rule-transform-name-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
          <xsl:value-of select="oja:name"/><xsl:value-of select="$newline"/>
          <xsl:if test="string-length(oja:description) &gt; 0">
            <xsl:text>rule-transform-description-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
            <xsl:value-of select="oja:description"/><xsl:value-of select="$newline"/>
          </xsl:if>
          <xsl:text>rule-transform-id-</xsl:text><xsl:value-of select="position()"/><xsl:text>:</xsl:text>
          <xsl:value-of select="@id"/><xsl:value-of select="$newline"/>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text># rule </xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text> has no transforms</xsl:text>
        <xsl:value-of select="$newline"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="string-length(oja:tip) &gt; 0">
      <xsl:text>rule-tooltip:</xsl:text><xsl:value-of select="oja:tip"/><xsl:value-of select="$newline"/>
    </xsl:if>
    <xsl:value-of select="$newline"/>
  </xsl:template>


  <!-- Metrics section -->
  <xsl:template match="/oja:profile-report/oja:metrics">
    <xsl:text># Metrics</xsl:text><xsl:value-of select="$newline"/>
    <xsl:for-each select="oja:metric">
      <xsl:call-template name="metric"/>
    </xsl:for-each>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <xsl:template name="metric">
    <xsl:text># metric - </xsl:text><xsl:value-of select="oja:name"/><xsl:value-of select="$newline"/>
    <xsl:text>metric-name:</xsl:text><xsl:value-of select="oja:name"/><xsl:value-of select="$newline"/>
    <xsl:text>metric-category:</xsl:text><xsl:value-of select="oja:category"/><xsl:value-of select="$newline"/>
    <xsl:text>metric-description:</xsl:text><xsl:value-of select="oja:description"/><xsl:value-of select="$newline"/>
    <xsl:text>metric-type:</xsl:text><xsl:value-of select="oja:type"/><xsl:value-of select="$newline"/>
    <xsl:choose>
      <xsl:when test="string-length(oja:threshhold) &gt; 0">
        <xsl:text>metric-threshhold:</xsl:text><xsl:value-of select="oja:threshhold"/><xsl:value-of select="$newline"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text># metric </xsl:text>
        <xsl:value-of select="oja:name"/>
        <xsl:text> has no threshhold</xsl:text>
        <xsl:value-of select="$newline"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="string-length(oja:tip) &gt; 0">
        <xsl:text>metric-tip:</xsl:text><xsl:value-of select="oja:tip"/><xsl:value-of select="$newline"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text># metric </xsl:text>
        <xsl:value-of select="oja:name"/>
        <xsl:text> has no tooltip</xsl:text>
        <xsl:value-of select="$newline"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="$newline"/>
  </xsl:template>

</xsl:stylesheet>