<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:oja="http://xmlns.oracle.com/jdeveloper/1013/audit">

  <!--
  - Converts Metrics report XML into a table with rows for each construct.
  -->

  
  <!--
  - This style sheet outputs plain text, by default using the UTF-8 encoding. 
  - When Audit applies the style sheet, it overrides the encoding attribute to 
  - the global JDeveloper encoding.
  -->
  <xsl:output method="text"/>


  <!--
  - The character sequence to use when outputting a line break.
  -
  - Unlike XML document consumers, some text document consumers expect a
  - particular line terminator sequence. Audit generates the XML document
  - using the line terminator indicated in the JDeveloper environment options,
  - and sets this parameter to the same line terminator sequence so that a 
  - careful style sheet can ensure that the output file has consistent
  - line terminators.
  -->
  <xsl:param name="newline">
<xsl:text>
</xsl:text>
  </xsl:param>


  <!--
  - Space to substring to pad columns to even widths.
  -->
  <xsl:variable name="space" select="'                                                        '"/>

  <!--
  - Compute the maximum width of the label column.
  -->
  <xsl:variable name="labelwidth">
    <xsl:for-each select="/oja:audit//oja:construct/oja:label">
      <xsl:sort select="string-length(.)" data-type="number" order="descending"/>
      <xsl:if test="position()=1">
        <xsl:value-of select="string-length(.)"/>
      </xsl:if>
    </xsl:for-each>
  </xsl:variable>

  <!--
  - Set a fixed maximum width for the value columns.
  -->
  <xsl:variable name="valuewidth" select="8"/>

  <!-- 
  -  Apply a template to each <construct> in the tree.
  -->
  <xsl:template match="/">
    <xsl:if test="string-length(/oja:audit/oja:title) > 0">
      <xsl:value-of select="/oja:audit/oja:title"/>
      <xsl:value-of select="$newline"/>
    </xsl:if>
    <xsl:apply-templates select="/oja:audit//oja:construct"/>
  </xsl:template>

  <!--
  - For a <construct>, output the value of the <label>, padding to the label
  - column width, and apply a template to each <value>, followed by a line 
  - break.
  -->
  <xsl:template match="oja:construct">
    <xsl:value-of select="oja:label"/>
    <xsl:value-of select="substring($space, 1, $labelwidth - string-length(oja:label))"/>
    <xsl:apply-templates select="oja:values/oja:value"/>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!--
  - For a <value>, output the value, padding to the value width.
  -->
  <xsl:template match="oja:value">
    <xsl:value-of select="substring($space, 1, $valuewidth - string-length(.))"/>
    <xsl:value-of select="."/>
  </xsl:template>

</xsl:stylesheet>
