<?xml version="1.0" encoding="US-ASCII" ?>

<!--
* This stylesheet transforms 9.0.5, 10.1.2 and 10.1.3 tool definition files
* to fix the class name of the external program tool. Although 11 no longer
* uses tools.xml, it relies on object2dom to be able to migrate tools from
* those earlier releases to 11, so we must deal with the change of package
* name before using the (reflection based) object2dom.
-->
<!DOCTYPE xsl:stylesheet [
<!ENTITY ns 'http://xmlns.oracle.com/jdeveloper/905/externaltools'>
<!ENTITY oldtoolclass 'oracle.jdevimpl.externaltools.program.ExternalProgramTool'>
<!ENTITY newtoolclass 'oracle.ideimpl.externaltools.program.ExternalProgramTool'>
]>

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:et="&ns;"
                xmlns="&ns;">

  <xsl:output indent="yes" />
  
  <!-- Identity transform -->
  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*" />
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <!-- Convert the old class name to the new class name -->
  <xsl:template match="et:tools/et:Item[@class='&oldtoolclass;']">
    <Item class="&newtoolclass;">
      <xsl:apply-templates />
    </Item>
  </xsl:template>
  
</xsl:stylesheet>
