<?xml version="1.0"?>
<!-- 
 Copyright (c) 2000, 2009, Oracle and/or its affiliates. All rights reserved. 
NAME
    kuxmlsch.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_xmlschema_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    dgagne      07/31/09 - add bind_pattern parse item
    spetride    06/09/09 - 8585496:schemaoid, extra options for registerSchema
    rapayne     06/01/09 - bug 8539628: allow schema_level to generate FORCE.
    sdavidso    03/26/07 - 5903231 - maintain binary storage for xmlschemas
    slynn       10/25/06 - add VERSION param
    lbarton     10/06/05 - bug 4516042: xmlschemas and SB tables in Data Pump 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    bmccarth    08/15/02 - remove schema
    bmccarth    08/08/02 - change strip_username to emit_Schema
    lbarton     07/24/02 - get stripped and unstripped val
    bmccarth    07/30/02 - bring 92 change forward FORCE set to TRUE
    htseng      08/02/02 - add grantee parse param
    htseng      07/29/02 - add more parse params
    lbarton     01/16/02 - Merged lbarton_mdapi_xdb
    lbarton     01/08/02 - api change
    lbarton     12/03/01 - use BEGIN...END
    lbarton     10/25/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <!-- Note dictionary default values must be considered also -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="GEN_TYPES">0</xsl:param>
 <xsl:param name="GEN_BEAN">0</xsl:param>
 <xsl:param name="GEN_TABLES">0</xsl:param>
 <xsl:param name="FORCE">1</xsl:param>
 <xsl:param name="EMIT_SCHEMA">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="VERSION">9999999999</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BIND_PATTERN">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="XMLSCHEMA_T">
  <!-- *******************************************************************
Template: XMLSCHEMA_T - top-level template for xml schemas
******************************************************************** -->
  <!-- emit the parse items if necessary -->

  <!-- calls to register schema need to have bind variables determined and
       passed in.  Set BIND_PATTERN=3 -->
  <xsl:if test="$PRS_BIND_PATTERN=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABIND_PATTERN</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B3</xsl:text>
  </xsl:if>

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">dbms_xmlschema.registerSchema</xsl:with-param>
   <xsl:with-param name="ObjectType">XMLSCHEMA</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="URL"/>
  </xsl:call-template>
  <!-- emit the registerSchema call -->
  <xsl:text>BEGIN dbms_xmlschema.registerSchema(</xsl:text>
  <xsl:choose>
   <!-- For export case (actually Data Pump import case), just return a canned
        registershemaschema call with bind arguments. At export time, the
        worker gets the xsd document as a clob along with other arguments as
        parse items. At import time, it uses the canned registerschema call
        and specifies the bind arguments with an EXECUTE IMMEDIAT ... USING ...
        call.
     -->
   <xsl:when test="$EXPORT=1">
    <xsl:text>:1, :2, (:3 = 1), </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:when>
   <!-- normal case: schemaurl, schemadoc, local -->
   <xsl:otherwise>
    <xsl:text>'</xsl:text>
    <xsl:value-of select="URL"/>
    <xsl:text>',</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text>'</xsl:text>
    <!-- schemadoc is either the XMLSchema itself (SCHEMA_VAL)
         or the XMLSchema with username stripped (STRIPPED_VAL) -->
    <xsl:choose>
     <xsl:when test="$EMIT_SCHEMA=1">
      <xsl:value-of select="SCHEMA_VAL"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="STRIPPED_VAL"/>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:text>',</xsl:text>
    <xsl:choose>
     <xsl:when test="(LOCAL mod 2) = 1">
      <xsl:text>TRUE,</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>FALSE,</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <!-- continue with remaining arguments: gentypes, genbean, gentables,
       force... -->
  <xsl:choose>
   <xsl:when test="$GEN_TYPES = 1">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="$GEN_BEAN = 1">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="$GEN_TABLES = 1">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="$FORCE = 1 or SCHEMA_LEVEL=0">
    <xsl:text>TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!-- Include owner name if requested -->
  <xsl:choose>
   <xsl:when test="$EXPORT=1">
    <xsl:text>, :4, options=> :5, schemaoid => :6, import_options => :7</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:choose>
     <xsl:when test="$EMIT_SCHEMA=1">
      <xsl:text>,'</xsl:text>
      <xsl:value-of select="OWNER_NAME"/>
      <xsl:text>'</xsl:text>
     </xsl:when>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="(LOCAL mod 4) >= 2">
      <xsl:text>, options=> DBMS_XMLSCHEMA.REGISTER_BINARYXML</xsl:text>
     </xsl:when>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>); END</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1 or $EXPORT=1">;</xsl:if>
  <xsl:if test="$PRETTY=1">&#xa;</xsl:if>
 </xsl:template>
</xsl:stylesheet>
