<?xml version="1.0"?>
<!--
NAME
    kutrig.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_trigger_t ADTs 
    This generates two DDL statements: a CREATE and an ALTER
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    mjangir     09/22/08 - bug 7417752: use double quots with trigger fire block
    tbhukya     04/23/08 - Bug 6858289: handle trigger fire only once property
    rdecker     08/15/06 - Add PLSCOPE_SETTINGS 
    masubram    06/01/06 - new trigger keywords 
    wesmith     05/16/06 - RegenTriggerDefn: add FOLLOWS, ENABLE/DIABLE
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      06/21/04 - add support plsql_ccflags 
    htseng      12/08/03 - compiler switch support 
    lbarton     10/20/03 - fetch trigger body as clob 
    htseng      09/11/03 - add compiler switches support 
    htseng      05/21/03 - bug 2967731: trigger body > 4000
    lbarton     04/09/03 - Bug 2893918: use parsed definition
    lbarton     12/11/02 - support REGEN_DEFN
    htseng      12/18/02 - add EXPORT parameter
    htseng      08/02/02 - add grantee parse param
    htseng      07/29/02 - add more parse params
    htseng      11/13/01 - fix bug 2106294 - missing schema name.
    lbarton	06/01/01 - remove oradb-style imports
    lbarton	10/16/00 - fix position of / sqlterminator
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="REGEN_DEFN">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_ENABLE">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="TRIGGER_T">
  <xsl:if test="$PRS_ENABLE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AENABLE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test="ENABLED=0">
     <xsl:text>DISABLE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>ENABLE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TRIGGER</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE </xsl:text>
  </xsl:if>
  <xsl:text>TRIGGER </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:choose>
   <xsl:when test="$REGEN_DEFN=0 or (VERS_MAJOR=1 and VERS_MINOR=0)
      or (PROPERTY mod 2)=1     or (PROPERTY mod 16)>= 8
      or (PROPERTY mod 32)>= 16 or (PROPERTY mod 64)>= 32">
    <xsl:choose>
     <xsl:when test="PARSED_DEF">
      <xsl:apply-templates select="PARSED_DEF"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="substring-after(DEFINITION,substring-before(normalize-space(DEFINITION),' '))"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="RegenTriggerDefn"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="WHENCLAUSE"/>
  <xsl:choose>
   <xsl:when test="BODY_VCNT">
    <xsl:choose>
     <!-- Have to strip trailing ';' off CALL triggers(go figure) -->
     <xsl:when test="(PROPERTY mod 4)>=2">
      <xsl:text> CALL </xsl:text>
      <xsl:for-each select="BODY_VCNT/BODY_VCNT_ITEM">
       <xsl:choose>
        <xsl:when test="position()=last() and 
		contains(substring(.,string-length(.)),';')">
         <xsl:value-of select="substring(.,1,string-length(.)-1)"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="."/>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text>&#xa; </xsl:text>
      </xsl:for-each>
     </xsl:when>
     <xsl:otherwise>
      <xsl:for-each select="BODY_VCNT/BODY_VCNT_ITEM">
       <xsl:value-of select="."/>
       <xsl:text>&#xa; </xsl:text>
      </xsl:for-each>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <!-- end length greater than 4000 -->
   <xsl:otherwise>
    <!-- body length less than 4000 -->
    <xsl:choose>
     <!-- Have to strip trailing ';' off CALL triggers(go figure) -->
     <xsl:when test="(PROPERTY mod 4)>=2">
      <xsl:text> CALL </xsl:text>
      <xsl:choose>
       <xsl:when test="contains(substring(BODY,string-length(BODY)),';')">
        <xsl:value-of select="substring(BODY,1,string-length(BODY)-1)"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="BODY"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="BODY"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <!-- Terminate trigger text with a '/' rather than ';' -->
   <xsl:text>
/</xsl:text>
  </xsl:if>
  <xsl:text>&#xa;</xsl:text>
  <xsl:apply-templates select="ENABLED"/>
  <xsl:apply-templates select="PROPERTY"/>
 </xsl:template>
 <xsl:template match="PARSED_DEF">
  <xsl:value-of select="substring(SOURCE,POST_NAME_OFF)"/>
 </xsl:template>
 <xsl:template match="WHENCLAUSE">
  <xsl:text> WHEN (</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>) </xsl:text>
 </xsl:template>
 <xsl:template match="ENABLED">
  <xsl:if test="$PRS_ENABLE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AENABLE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test=".=0">
     <xsl:text>DISABLE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>ENABLE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">TRIGGER</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="../SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="../SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>ALTER TRIGGER </xsl:text>
  <xsl:apply-templates select="../SCHEMA_OBJ"/>
  <xsl:choose>
   <xsl:when test=".=0">
    <xsl:text>DISABLE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>ENABLE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <!--compiler switch -->
  <xsl:if test="$EXPORT=1 and ../COMPILER_INFO">
   <xsl:text>&#xa;</xsl:text>
   <!-- switch compiler info  -->
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">TRIGGER</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="../SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="../SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <!--compiler switch -->
   <xsl:text>ALTER TRIGGER </xsl:text>
   <xsl:apply-templates select="../SCHEMA_OBJ"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>  COMPILE </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>    PLSQL_OPTIMIZE_LEVEL=  </xsl:text>
   <xsl:value-of select="../COMPILER_INFO/OPTLEVEL"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>    PLSQL_CODE_TYPE=  </xsl:text>
   <xsl:value-of select="../COMPILER_INFO/CODETYPE"/>
   <xsl:if test="COMPILER_INFO/DEBUG">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>    PLSQL_DEBUG=  </xsl:text>
    <xsl:value-of select="../COMPILER_INFO/DEBUG"/>
   </xsl:if>
   <xsl:if test="string-length(../COMPILER_INFO/CCFLAGS)!=0">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>    PLSQL_CCFLAGS=  '</xsl:text>
    <xsl:value-of select="../COMPILER_INFO/CCFLAGS"/>
    <xsl:text>'</xsl:text>
   </xsl:if>
   <xsl:text>    PLSCOPE_SETTINGS=  '</xsl:text>
   <xsl:value-of select="../COMPILER_INFO/PLSCOPE"/>
   <xsl:text>'</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
    <!-- Terminate the SQL statement -->
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template match="PROPERTY">
  <!-- Set_trigger_firing_property is not valid for instead of,
       nested table, call, database with system events triggers -->
  <xsl:if test="not((. mod (128*2))-(. mod 128) or 
                    (. mod (1*2))-(. mod 1) or 
                    (. mod (2*2))-(. mod 2) or
                    ((. mod (2*8))-(. mod 8) and
                         ((../SYS_EVTS div 2)&lt;16 
                               or (../SYS_EVTS mod 8388608)=0
                         )
                    ) or 
                    (. mod (32*2))-(. mod 32))">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_DDL.SET_TRIGGER_FIRING_PROPERTY
    </xsl:with-param>
    <xsl:with-param name="ObjectType">TRIGGER</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="../SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="../SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>BEGIN </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>  DBMS_DDL.SET_TRIGGER_FIRING_PROPERTY('"</xsl:text>
   <xsl:value-of select="../SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:text>"','"</xsl:text>
   <xsl:value-of select="../SCHEMA_OBJ/NAME"/>
   <xsl:text>"',FALSE) ; </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>END;</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>/</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="RegenTriggerDefn">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="TYPE_NUM=0 or TYPE_NUM=1">
    <xsl:text>BEFORE </xsl:text>
   </xsl:when>
   <xsl:when test="TYPE_NUM=2 or TYPE_NUM=3">
    <xsl:text>AFTER </xsl:text>
   </xsl:when>
   <xsl:when test="TYPE_NUM=4">
    <xsl:text>INSTEAD OF </xsl:text>
   </xsl:when>
   <xsl:when test="TYPE_NUM=5">
    <xsl:text>FOR </xsl:text>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="ACT_UPDATE!=0">
   <xsl:text>UPDATE </xsl:text>
  </xsl:if>
  <xsl:if test="ACT_INSERT!=0">
   <xsl:if test="ACT_UPDATE!=0">
    <xsl:text>OR </xsl:text>
   </xsl:if>
   <xsl:text>INSERT </xsl:text>
  </xsl:if>
  <xsl:if test="ACT_DELETE!=0">
   <xsl:if test="ACT_UPDATE!=0 or ACT_INSERT!=0">
    <xsl:text>OR </xsl:text>
   </xsl:if>
   <xsl:text>DELETE </xsl:text>
  </xsl:if>
  <xsl:for-each select="COLS/COLS_ITEM[TYPE_NUM=0]">
   <xsl:if test="position()=1">
    <xsl:text>OF </xsl:text>
   </xsl:if>
   <xsl:if test="position()!=1">
    <xsl:text>, </xsl:text>
   </xsl:if>
   <!--xsl:value-of select="NAME"/-->
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="current()"/>
   </xsl:call-template>
   <xsl:if test="position()=last()">
    <xsl:text> </xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:text>ON </xsl:text>
  <xsl:apply-templates select="BASE_OBJ"/>
  <xsl:if test="REFOLDNAME!='OLD' or REFNEWNAME!='NEW'">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>REFERENCING </xsl:text>
   <xsl:if test="REFOLDNAME!='OLD'">
    <xsl:text>OLD AS </xsl:text>
    <xsl:value-of select="REFOLDNAME"/>
    <xsl:text> </xsl:text>
   </xsl:if>
   <xsl:if test="REFNEWNAME!='NEW'">
    <xsl:text>NEW AS </xsl:text>
    <xsl:value-of select="REFNEWNAME"/>
    <xsl:text> </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="TYPE_NUM=1 or TYPE_NUM=3">
   <xsl:text>FOR EACH ROW </xsl:text>
  </xsl:if>
  <xsl:choose>
    <xsl:when test="(PROPERTY mod 131072)>=65536">
      <xsl:text>FORWARD </xsl:text>
    </xsl:when>
    <xsl:when test="(PROPERTY mod 262144)>=131072">
      <xsl:text>REVERSE </xsl:text>
    </xsl:when>
  </xsl:choose>
  <xsl:if test="(PROPERTY mod 16384)>=8192">
    <xsl:text>CROSSEDITION </xsl:text>
  </xsl:if>
  <xsl:choose>
    <xsl:when test="(PROPERTY mod 32768)>=16384">
      <xsl:text>FOLLOWS </xsl:text>
    </xsl:when>
    <xsl:when test="(PROPERTY mod 65536)>=32768">
      <xsl:text>PRECEDES </xsl:text>
    </xsl:when>
  </xsl:choose>
  <xsl:for-each select="TRIGDEPS/TRIGDEPS_ITEM">
   <xsl:if test="position()!=1">
    <xsl:text>, </xsl:text>
   </xsl:if>
   <!-- if bit(flag, 4) = 0, then explicitly output the trigger owner -->
   <xsl:if test="(FLAG mod 8)&lt;4">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="P_TRGOWNER"/>
    <xsl:text>".</xsl:text>
   </xsl:if>
   <xsl:text>"</xsl:text>
   <xsl:value-of select="P_TRGNAME"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="position()=last()">
    <xsl:text> </xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:if test="ENABLED=0">
   <xsl:text>DISABLE </xsl:text>
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
