<?xml version="1.0"?>
<!--
NAME
    kusqtabd.xsl
DESCRIPTION
    Convert AQ_QUEUE_TABLE (SXML) document to creation DDL.

MODIFIED        MM/DD/YY
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton    08/10/05 - lbarton_mddiff
    lbarton    07/08/05 - 
    htseng     04/13/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for  AQ_QUEUE_TABLE.


******************************************************************** -->
 <xsl:template match="sxml:AQ_QUEUE_TABLE">
  <xsl:text> BEGIN DBMS_AQADM.CREATE_QUEUE_TABLE(</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Queue_table        => '</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>',</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Queue_payload_type => '</xsl:text>
  <xsl:if test="sxml:QUEUE_PAYLOAD_TYPE/sxml:SCHEMA">
   <xsl:value-of select="sxml:QUEUE_PAYLOAD_TYPE/sxml:SCHEMA"/>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:value-of select="sxml:QUEUE_PAYLOAD_TYPE/sxml:NAME"/>
  <xsl:text>',</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>storage_clause     => '</xsl:text>
  <xsl:call-template name="SegmentAttributes">
   <xsl:with-param name="ParentNode" select="sxml:SEGMENT_ATTRIBUTES"/>
  </xsl:call-template>
  <xsl:text>'</xsl:text>
  <xsl:if test="sxml:SORT_LIST">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Sort_list          => '</xsl:text>
   <xsl:value-of select="sxml:SORT_LIST"/>
   <xsl:text>'</xsl:text>
  </xsl:if>
  <xsl:text>,</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Multiple_consumers =>  </xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:MULTIPLE_CONSUMERS">
    <xsl:text>TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="sxml:MESSAGE_GROUPING">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Message_grouping   => 1</xsl:text>
  </xsl:if>
  <xsl:text>,</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Compatible         =>  '</xsl:text>
  <xsl:value-of select="sxml:COMPATIBLE"/>
  <xsl:text>'</xsl:text>
  <xsl:if test="sxml:COMMENT">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Comment            => '</xsl:text>
   <xsl:value-of select="sxml:COMMENT"/>
   <xsl:text>'</xsl:text>
  </xsl:if>
  <xsl:if test="sxml:PRIMARY_INSTANCE">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Primary_instance   => </xsl:text>
   <xsl:value-of select="sxml:PRIMARY_INSTANCE"/>
  </xsl:if>
  <xsl:if test="sxml:SECONDARY_INSTANCE">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Secondary_instance   => </xsl:text>
   <xsl:value-of select="sxml:SECONDARY_INSTANCE"/>
  </xsl:if>
  <xsl:text>,</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Secure             =>  </xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:SECURE">
    <xsl:text>TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>);</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> END;</xsl:text>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
