<?xml version="1.0"?>
<!--
 Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
NAME
    kusmvd.xsl
DESCRIPTION
    Convert MATERIALIZED_VIEW (SXML) document to creation DDL.

MODIFIED        MM/DD/YY
    abodge      09/22/09 - CONSOLIDATE STYLESHEETS: Gen comments
    lbarton     10/15/07 - PARSED_SUBQUERY
    lbarton     01/02/08 - bug 6720629: column aliases
    slynn       02/25/07 - Backout changes that removed dedup validate.
    lbarton     12/13/06 - securefile changes
    slynn       11/20/06 - Remove unimplemented keywords
    slynn       10/12/06 - smartfile->securefile
    slynn       07/31/06 - change csce keywords
    jforsyth    05/10/06 - adding encryption, compression, sharing 
    mbaloglu    05/03/06 - lrg-2193745: fix a typo 
    kkunchit    11/01/05 - project-18204: inode: LOCAL/NOLOCAL support 
    mbaloglu    12/23/05 - Project 18207: Add SYNC/ASYNC 
    htseng      01/05/06 - add transform param 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     09/15/05 - SXML changes required by XML schema
    htseng      08/25/05 - add trusted constraints 
    lbarton     08/10/05 - lbarton_mddiff
    htseng      05/03/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kusindxd.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- Param for genetrating comments ddl (Change Mgr) -->
 <xsl:param name="COMMENTS">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for MATERIALIZED_VIEW.
******************************************************************** -->
 <xsl:template match="sxml:MATERIALIZED_VIEW">
  <xsl:text>CREATE MATERIALIZED VIEW </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:if test="sxml:OF_TYPE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> OF </xsl:text>
   <xsl:call-template name="SchemaName">
    <xsl:with-param name="ParentNode" select="sxml:OF_TYPE"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="sxml:COL_LIST">
   <xsl:text> (</xsl:text>
   <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
    <xsl:choose>
     <xsl:when test="contains(sxml:NAME,'&quot;')">
      <xsl:value-of select="sxml:NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>"</xsl:text>
      <xsl:value-of select="sxml:NAME"/>
      <xsl:text>"</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="not(position()=last())">,</xsl:if>
   </xsl:for-each>
   <xsl:text>) </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:ON_PREBUILT_TABLE">
   <xsl:text> ON PREBUILT TABLE</xsl:text>
   <xsl:choose>
    <xsl:when test="sxml:ON_PREBUILT_TABLE/sxml:REDUCED_PRECISION='Y'">
     <xsl:text> WITH</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text> WITHOUT</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:text> REDUCED PRECISION</xsl:text>
  </xsl:if>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:choose>
    <xsl:when test="sxml:RANGE_PARTITIONING">
     <xsl:apply-templates select="sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    </xsl:when>
    <xsl:when test="sxml:HASH_PARTITIONING">
     <xsl:apply-templates select="sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    </xsl:when>
    <xsl:when test="sxml:LIST_PARTITIONING">
     <xsl:apply-templates select="sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:apply-templates select="sxml:PHYSICAL_PROPERTIES"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <!-- xsl:apply-templates select="sxml:COLUMN_PROPERTIES"/ -->
   <!-- column_properties -->
   <xsl:for-each select="sxml:COLUMN_PROPERTIES/sxml:COL_LIST/sxml:COL_LIST_ITEM">
    <xsl:if test="sxml:DATATYPE='CLOB' or sxml:DATATYPE='LOB'">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text>LOB (</xsl:text>
     <xsl:call-template name="QuotedName">
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
     <xsl:if test="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE">
      <xsl:call-template name="DoMVStoreAs">
       <xsl:with-param name="StorageTable" select="sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE"/>
      </xsl:call-template>
     </xsl:if>
    </xsl:if>
   </xsl:for-each>
  </xsl:if>
  <!-- table_partitioning -->
  <xsl:if test="sxml:RANGE_PARTITIONING">
   <xsl:call-template name="TableRangePartitioning">
    <xsl:with-param name="PartitioningNode" select="sxml:RANGE_PARTITIONING"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="sxml:LIST_PARTITIONING">
   <xsl:call-template name="TableListPartitioning">
    <xsl:with-param name="PartitioningNode" select="sxml:LIST_PARTITIONING"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="sxml:HASH_PARTITIONING">
   <xsl:call-template name="TableHashPartitioning">
    <xsl:with-param name="PartitioningNode" select="sxml:HASH_PARTITIONING"/>
   </xsl:call-template>
  </xsl:if>
  <!-- cache -->
  <xsl:if test="sxml:CACHE"> CACHE</xsl:if>
  <!-- parallel_clause  -->
  <xsl:if test="sxml:PARALLEL">
   <xsl:apply-templates select="sxml:PARALLEL"/>
  </xsl:if>
  <xsl:apply-templates select="sxml:BUILD"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:USING_NO_INDEX">
    <xsl:text> USING NO INDEX</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> USING INDEX</xsl:text>
    <xsl:if test="($SEGMENT_ATTRIBUTES=1) and (sxml:INDEX_ATTRIBUTES)">
     <xsl:call-template name="IndexAttributes">
      <xsl:with-param name="AttNode" select="sxml:INDEX_ATTRIBUTES"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <!-- Refresh_clause -->
  <xsl:choose>
   <xsl:when test="sxml:NEVER_REFRESH">
    <xsl:text> NEVER REFRESH</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="sxml:REFRESH"/>
   </xsl:otherwise>
  </xsl:choose>
  <!-- update_clause -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:FOR_UPDATE">
   <xsl:text> FOR UPDATE</xsl:text>
  </xsl:if>
  <!-- query_rewrite  -->
  <xsl:choose>
   <xsl:when test="sxml:QUERY_REWRITE">
    <xsl:text> ENABLE QUERY REWRITE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> DISABLE QUERY REWRITE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!-- SUBQUERY or PARSED_SUBQUERY -->
  <xsl:apply-templates select="sxml:SUBQUERY"/>
  <xsl:apply-templates select="sxml:PARSED_SUBQUERY"/>
  <xsl:if test="$COMMENTS=1 and sxml:COMMENTS">
   <xsl:call-template name="CommentsOn">
    <xsl:with-param name="ObjectType">MATERIALIZED VIEW</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SUBQUERY">
 <!-- *******************************************************************
Template: SUBQUERY
******************************************************************** -->
   <xsl:text> AS </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:value-of select="."/>
 </xsl:template>
 <xsl:template match="sxml:PARSED_SUBQUERY">
 <!-- *******************************************************************
Template: PARSED_SUBQUERY
******************************************************************** -->
   <xsl:text> AS </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:apply-templates select="*[1]">
    <xsl:with-param name="InnerQuery">0</xsl:with-param>
   </xsl:apply-templates>
 </xsl:template>
 <!-- *******************************************************************
Template: DoMVStoreAs
******************************************************************** -->
 <xsl:template name="DoMVStoreAs">
  <xsl:param name="StorageTable" select="''"/>
  <xsl:text> STORE AS </xsl:text>
  <xsl:choose>
   <xsl:when test="$StorageTable/sxml:SECUREFILE">
    <xsl:text> SECUREFILE </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> BASICFILE </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>(</xsl:text>
  <!-- storage_table -->
  <xsl:if test="$StorageTable">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:if test="$StorageTable/sxml:TABLESPACE">
    <xsl:text> TABLESPACE "</xsl:text>
    <xsl:value-of select="$StorageTable/sxml:TABLESPACE"/>
    <xsl:text>"</xsl:text>
   </xsl:if>
   <xsl:if test="$StorageTable/sxml:STORAGE_IN_ROW">
    <xsl:text> ENABLE STORAGE IN ROW</xsl:text>
   </xsl:if>
   <xsl:if test="$StorageTable/sxml:CHUNK">
    <xsl:text> CHUNK </xsl:text>
    <xsl:value-of select="$StorageTable/sxml:CHUNK"/>
   </xsl:if>
   <xsl:if test="$StorageTable/sxml:PCTVERSION">
    <xsl:text> PCTVERSION </xsl:text>
    <xsl:value-of select="$StorageTable/sxml:PCTVERSION"/>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="$StorageTable/sxml:CACHE='N'">
     <xsl:text> NOCACHE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text> CACHE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$StorageTable/sxml:SECUREFILE">
   <!-- encryption -->
   <xsl:choose>
     <xsl:when test="$StorageTable/sxml:LOBENCRYPT">
      <xsl:text> ENCRYPT</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text> DECRYPT</xsl:text>
     </xsl:otherwise>
   </xsl:choose>
   <!-- compression -->
   <xsl:choose>
    <xsl:when test="$StorageTable/sxml:LOBCOMPRESS='HIGH'">
     <xsl:text> COMPRESS HIGH</xsl:text>
    </xsl:when>
    <xsl:when test="$StorageTable/sxml:LOBCOMPRESS='MEDIUM'">
     <xsl:text> COMPRESS MEDIUM</xsl:text>
    </xsl:when>
    <xsl:when test="$StorageTable/sxml:LOBCOMPRESS='LOW'">
     <xsl:text> COMPRESS LOW</xsl:text>
    </xsl:when>
    <xsl:when test="$StorageTable/sxml:LOBCOMPRESS='N'">
     <xsl:text> NOCOMPRESS</xsl:text>
    </xsl:when>
   </xsl:choose>
   <!-- deduplicate -->
   <xsl:choose>
    <xsl:when test="$StorageTable/sxml:DEDUPLICATE='OBJECT'">
     <xsl:text> DEDUPLICATE OBJECT</xsl:text>
    </xsl:when>
    <xsl:when test="$StorageTable/sxml:DEDUPLICATE='LOB'">
     <xsl:text> DEDUPLICATE LOB</xsl:text>
    </xsl:when>
    <xsl:when test="$StorageTable/sxml:DEDUPLICATE='N'">
     <xsl:text> KEEP_DUPLICATES</xsl:text>
    </xsl:when>
   </xsl:choose>
 </xsl:if>
   <!-- deduplicate validation -->
   <xsl:choose>
    <xsl:when test="$StorageTable/sxml:VALIDATE='Y'">
     <xsl:text> VALIDATE</xsl:text>
    </xsl:when>
   </xsl:choose>
   <xsl:apply-templates select="$StorageTable/sxml:LOGGING"/>
   <!-- storage -->
   <xsl:if test="$StorageTable/sxml:STORAGE">
    <xsl:call-template name="Storage">
     <xsl:with-param name="StorageNode" select="$StorageTable/sxml:STORAGE"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:if>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <!-- *******************************************************************
Template: BUILD
******************************************************************** -->
 <xsl:template match="sxml:BUILD">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> BUILD </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <!-- *******************************************************************
Template: REFRESH
******************************************************************** -->
 <xsl:template match="sxml:REFRESH">
  <xsl:text> REFRESH</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:FAST"> FAST</xsl:when>
   <xsl:when test="sxml:COMPLETE"> COMPLETE</xsl:when>
   <xsl:otherwise> FORCE</xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="sxml:ON_COMMIT"> ON COMMIT</xsl:when>
   <xsl:otherwise> ON DEMAND</xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$PRETTY=1 and (sxml:START_WITH or sxml:NEXT)">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="sxml:START_WITH"/>
  <xsl:apply-templates select="sxml:NEXT"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:WITH_ROWID"> WITH ROWID</xsl:when>
   <xsl:when test="sxml:WITH_PRIMARY_KEY"> WITH PRIMARY KEY</xsl:when>
  </xsl:choose>
  <xsl:apply-templates select="sxml:MASTER_ROLLBACK_SEGMENT"/>
  <xsl:apply-templates select="sxml:LOCAL_ROLLBACK_SEGMENT"/>
  <!-- Refresh constraints -->
  <xsl:apply-templates select="sxml:CONSTRAINTS"/>
 </xsl:template>
 <!-- *******************************************************************
Template: START_WITH
******************************************************************** -->
 <xsl:template match="sxml:START_WITH">
  <xsl:text> START WITH </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <!-- *******************************************************************
Template: NEXT
******************************************************************** -->
 <xsl:template match="sxml:NEXT">
  <xsl:text> NEXT </xsl:text>
  <xsl:value-of select="."/>
 </xsl:template>
 <!-- *******************************************************************
Template: MASTER_ROLLBACK_SEGMENT | LOCAL_ROLLBACK_SEGMENT
******************************************************************** -->
 <xsl:template match="sxml:MASTER_ROLLBACK_SEGMENT |
                     sxml:LOCAL_ROLLBACK_SEGMENT">
  <xsl:text> USING</xsl:text>
  <xsl:if test="sxml:DEFAULT"> DEFAULT</xsl:if>
  <xsl:choose>
   <xsl:when test="local-name(.)='MASTER_ROLLBACK_SEGMENT'"> MASTER</xsl:when>
   <xsl:otherwise> LOCAL</xsl:otherwise>
  </xsl:choose>
  <xsl:text> ROLLBACK SEGMENT </xsl:text>
  <xsl:value-of select="sxml:NAME"/>
 </xsl:template>
 <!-- *******************************************************************
Template: CONSTRAINTS
******************************************************************** -->
 <xsl:template match="sxml:CONSTRAINTS">
  <!-- Suppress generation of USING ENFORCED CONSTRAINTS (the default)
       because it causes ORA-00905: missing keyword on 10.2.xxx -->
  <xsl:if test="$VERSION>=1101000000 or (.!='ENFORCED')">
   <xsl:text> USING </xsl:text>
   <xsl:value-of select="."/>
   <xsl:text> CONSTRAINTS</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
