<?xml version="1.0"?>
<!-- 
NAME
    kuqtrans.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_qtrans_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne 11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng  08/02/02 - add grantee parse param
    htseng  07/26/02 - add more parse params
    htseng  03/04/02 - setup default value for EXPORT.
    htseng  01/10/02 - make all DBMS_TRANSFORM_EXIMP calls in one begin/end block.
    htseng  11/08/01 - bug 2100506 -follow the object_type roule.
    htseng  10/24/01 - change EXECUTE to BEGIN/END.
    htseng  09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng  08/17/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="QTRANS_T">
  <xsl:if test="$EXPORT=0">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_TRANSFORM.CREATE_TRANSFORMATION</xsl:with-param>
    <xsl:with-param name="ObjectType">AQ_TRANSFORM</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_NAME"/>
    <xsl:with-param name="NameNode" select="TRANSFORM_NAME"/>
   </xsl:call-template>
   <xsl:text> BEGIN SYS.DBMS_TRANSFORM.CREATE_TRANSFORMATION(</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Schema       => '</xsl:text>
   <xsl:value-of select="SCHEMA_NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>name         => '</xsl:text>
   <xsl:value-of select="TRANSFORM_NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>From_schema  => '</xsl:text>
   <xsl:value-of select="FROM_OBJ/OWNER_NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>From_type    => '</xsl:text>
   <xsl:value-of select="FROM_OBJ/NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>To_schema    => '</xsl:text>
   <xsl:value-of select="TO_OBJ/OWNER_NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>To_type      => '</xsl:text>
   <xsl:value-of select="TO_OBJ/NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Transformation=>  '</xsl:text>
   <xsl:value-of select="SQL_EXPRESSION"/>
   <xsl:text>')</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> END</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- $EXPORT=0 -->
  <xsl:if test="$EXPORT=1">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_TRANSFORM_EXIMP</xsl:with-param>
    <xsl:with-param name="ObjectType">AQ_TRANSFORM</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_NAME"/>
    <xsl:with-param name="NameNode" select="TRANSFORM_NAME"/>
   </xsl:call-template>
   <xsl:text> BEGIN </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text>     SYS.DBMS_TRANSFORM_EXIMP.IMPORT_TRANSFORMATION('</xsl:text>
   <xsl:value-of select="SCHEMA_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="TRANSFORM_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="FROM_OBJ/OWNER_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="FROM_OBJ/NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="TO_OBJ/OWNER_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="TO_OBJ/NAME"/>
   <xsl:text>')</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text>     SYS.DBMS_TRANSFORM_EXIMP.IMPORT_TRANS_ATTR('</xsl:text>
   <xsl:value-of select="SCHEMA_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="TRANSFORM_NAME"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="ATTRIBUTE_NUM"/>
   <xsl:text>','</xsl:text>
   <xsl:value-of select="SQL_EXPRESSION"/>
   <xsl:text>')</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> END</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- $EXPORT=1 -->
 </xsl:template>
</xsl:stylesheet>
