<?xml version="1.0"?>
<!-- 
NAME
    kuprscom.xsl
DESCRIPTION
    Templates for generating parse items for XMLTypes
NOTES
    

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     11/14/02 - add missing support
    lbarton     06/17/02 - support table/index_stats
    lbarton	04/17/02 - new parse items
    lbarton	03/25/02 - bugfix
    lbarton	03/18/02 - lbarton_mdapi_dpumpinfra
    lbarton	03/13/02 - bugfix
    lbarton	02/06/01 - Created

 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- All DDL is text, and this is the only way to correctly render '<' -->
 <xsl:output method="text"/>
 <xsl:template match="/">
  <xsl:for-each select="RESULTSET/ROW | ROWSET/ROW">
   <xsl:if test="$PRS_ROW=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>D</xsl:text>
    <xsl:value-of select="position()"/>
    <xsl:value-of select="$PRS_DELIM"/>
   </xsl:if>
   <xsl:apply-templates/>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="ParseObjtype">
  <xsl:param name="Objtype">0</xsl:param>
  <xsl:if test="$PRS_OBJECT_TYPE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AOBJECT_TYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$Objtype!=0">
     <xsl:value-of select="$Objtype"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="SCHEMA_OBJ/TYPE_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseSchema">
  <xsl:param name="SchemaNode" select="''"/>
  <xsl:if test="$PRS_SCHEMA=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$SchemaNode != ''">
     <xsl:value-of select="$SchemaNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseName">
  <xsl:param name="NameNode" select="''"/>
  <xsl:if test="$PRS_NAME=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ANAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$NameNode != ''">
     <xsl:value-of select="$NameNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseBaseObjSchema">
  <xsl:param name="SchemaNode" select="''"/>
  <xsl:if test="$PRS_BASE_OBJECT_SCHEMA=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABASE_OBJECT_SCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$SchemaNode != ''">
     <xsl:value-of select="$SchemaNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseBaseObjName">
  <xsl:param name="NameNode" select="''"/>
  <xsl:if test="$PRS_BASE_OBJECT_NAME=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABASE_OBJECT_NAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$NameNode != ''">
     <xsl:value-of select="$NameNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="BASE_OBJ/NAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseBaseObjType">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="Objtype">0</xsl:param>
  <xsl:if test="$PRS_BASE_OBJECT_TYPE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABASE_OBJECT_TYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$Objtype!=0">
     <xsl:value-of select="$Objtype"/>
    </xsl:when>
    <xsl:when test="$TypeNode != ''">
     <xsl:value-of select="$TypeNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="BASE_OBJ/TYPE_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseGrantee">
  <xsl:param name="GranteeNode" select="''"/>
  <xsl:if test="$PRS_GRANTEE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AGRANTEE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$GranteeNode != ''">
     <xsl:value-of select="$GranteeNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="GRANTEE"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseGrantor">
  <xsl:param name="GrantorNode" select="''"/>
  <xsl:if test="$PRS_GRANTOR=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AGRANTOR</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$GrantorNode != ''">
     <xsl:value-of select="$GrantorNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="GRANTOR"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ParseTablespace">
  <xsl:param name="TablespaceNode" select="''"/>
  <xsl:if test="$PRS_TABLESPACE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ATABLESPACE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="$TablespaceNode != ''">
     <xsl:value-of select="$TablespaceNode"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="TS_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
