<?xml version="1.0"?>
<!-- 
NAME
    kuprocac.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_procact_t ADTs
    XSLT stylesheet for XML => DDL conversion of ku$_procact_instance_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton	10/02/02 - bugfix
    dgagne	08/29/02 - make ddl returned one statement by adding begin/end
    htseng	08/02/02 - add grantee parse param
    htseng	07/26/02 - add more parse params
    htseng	05/23/02 - htseng_proc_obj_api
    htseng	05/21/02 - add PROCDEBOBJG_T.
    htseng 	05/09/02 - add $CONNECT_PROCEDURE parameter.
    htseng 	05/09/02 - remove $EXPORT parameter.
    htseng	04/30/02 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="CONNECT_PROCEDURE" select=""/>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="PROCACTSYS_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="ObjectType">PROCACT_SYSTEM</xsl:with-param>
  </xsl:call-template>
  <xsl:apply-templates select="EXP_STRING"/>
 </xsl:template>
 <xsl:template match="PROCOBJG_T | PROCDEPOBJG_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='PROCOBJG_T'">PROCOBJ_GRANT</xsl:when>
     <xsl:when test="local-name(.)='PROCDEPOBJG_T'">PROCDEPOBJ_GRANT</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:apply-templates select="EXP_STRING"/>
 </xsl:template>
 <xsl:template match="EXP_STRING">
  <xsl:text>BEGIN </xsl:text>
  <xsl:for-each select="EXP_STRING_ITEM">
   <xsl:if test="string-length($CONNECT_PROCEDURE)!=0 
				and string-length(GRANTOR)!=0">
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>      BEGIN </xsl:text>
    <xsl:value-of select="$CONNECT_PROCEDURE"/>
    <xsl:text> ('</xsl:text>
    <xsl:value-of select="GRANTOR"/>
    <xsl:text>'); END;</xsl:text>
   </xsl:if>
   <xsl:apply-templates select="CODE"/>
  </xsl:for-each>
  <xsl:text>&#xa;  </xsl:text>
  <xsl:text>END; </xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>/
</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="CODE">
  <xsl:for-each select="CODE_ITEM">
   <xsl:value-of select="."/>
   <xsl:text>&#xa;</xsl:text>
   <xsl:if test="(position()=last()) and ($SQLTERMINATOR=1)">
    <xsl:text>/</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
