<?xml version="1.0"?>

<!--

 Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kumview.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_m_view_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    abodge      09/25/09 - CONSOLIDATE STYLESHEETS: Fix storage generation for
                           10.2
    lbarton     06/15/09 - remove hybrid columnar noise words
    lbarton     04/28/09 - archive level compression
    rapayne     12/06/08 - merge BLOCKSIZE logic for CM
    lbarton     01/26/09 - change calls to kutable templates
    wesmith     03/20/08 - Project 25482: add MVIEW/FLAG3
    mjangir     11/04/07 - Bug 5607386: support emit schema option
    mjangir     08/29/07 - Bug 5881123: add coln alias for materialized view
    cchiappa    06/10/06 - ORGANIZATION CUBE MVs 
    sramakri    04/12/06 - set mv-version to 9 in USING clause and minor to 2
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      08/08/05 - bug 3560220: get correct behavior from processor 
    htseng      08/25/05 - bug 4549356: support using trusted constraints 
    htseng      04/07/04 - bug 3550722: generate ALTER statement only $EXPORT 
                           is set 
    mxiao       12/18/03 - synonym list in create materialized view ddl 
    lbarton     12/04/03 - Bug: bad test for WITH ROWID 
    htseng      09/16/03 - fix bug 3116063 
    lbarton     08/19/03 - LRG 1558947: suppress index parallel 
    lbarton     07/15/03 - Bug 3045654: nested table tablespace if vsn >= 10
    wesmith     05/20/03 - fix MV syntax in template DoExpMV
    dgagne      01/02/03 - fix mv for datapump export/import
    htseng      11/26/02 - add alter clause
    htseng      10/11/02 - fix bug 2616047 - query length is greater than 4000
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     08/02/02 - transportable export
    htseng      04/02/02 - fix problem - add space before keyword USING.
    lbarton     01/16/02 - bugfix
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <xsl:import href="kutable.xsl"/>
 <xsl:import href="kuiot.xsl"/>
 <xsl:import href="kucot.xsl"/>
 <xsl:import href="kuprtobj.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="START_WITH">0</xsl:param>
 <!-- the following are for storage parameters only -->
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="VERSION">9999999999</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <!-- Template to recreate MATERIALIZED VIEW -->
 <xsl:template match="M_VIEW_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">MATERIALIZED VIEW</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="MVIEW/SOWNER"/>
   <xsl:with-param name="NameNode" select="MVIEW/VNAME"/>
  </xsl:call-template>
  <xsl:text>CREATE MATERIALIZED VIEW "</xsl:text>
  <xsl:if test="$EMIT_SCHEMA=1">
   <xsl:value-of select="MVIEW/SOWNER"/>
   <xsl:text>"."</xsl:text>
  </xsl:if> 
  <xsl:value-of select="MVIEW/VNAME"/>
  <xsl:text>"</xsl:text>
  <!--Bug 5881123: add supoort for columns aliases  -->
  <xsl:choose>
   <xsl:when test="(MVIEW/OBJFLAG mod 4) >= 2">
    <xsl:if test="$PRETTY=1 and $EXPORT=0">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> OF "</xsl:text>
    <xsl:value-of select="MVIEW/SNA_TYPE_OWNER"/>
    <xsl:text>"."</xsl:text>
    <xsl:value-of select="MVIEW/SNA_TYPE_NAME"/>
    <xsl:text>" </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> (</xsl:text>
    <xsl:apply-templates select="MVIEW_TAB/COL_LIST">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
     <xsl:with-param name="DoLF">0</xsl:with-param>
     <xsl:with-param name="DoHidden">0</xsl:with-param>
     <xsl:with-param name="Mview">1</xsl:with-param>
    </xsl:apply-templates>
    <xsl:text>)</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="$EXPORT=1">
    <xsl:call-template name="DoExpMV"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoMetaDataMV"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <!-- Generate ALTER MV COMPILE for primary MVs -->
  <!-- only EXPORT transform param is set up TRUE -->
  <xsl:if test="$EXPORT=1 and not(MVIEW/PARENT_SOWNER or MVIEW/PARENT_VNAME)">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">MATERIALIZED VIEW</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="MVIEW/SOWNER"/>
    <xsl:with-param name="NameNode" select="MVIEW/VNAME"/>
   </xsl:call-template>
   <xsl:text> ALTER MATERIALIZED VIEW "</xsl:text>
   <xsl:value-of select="MVIEW/SOWNER"/>
   <xsl:text>"."</xsl:text>
   <xsl:value-of select="MVIEW/VNAME"/>
   <xsl:text>" COMPILE</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
    <!-- Terminate the SQL statement -->
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoMetaDataMV">
  <xsl:if test="(MVIEW/FLAG mod 262144) &lt; 131072">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="(MVIEW/FLAG mod 67108865) >= 33554432">
     <xsl:text> ORGANIZATION INDEX </xsl:text>
     <xsl:choose>
      <xsl:when test="MVIEW_TAB/NUMKEYCOLS > 0">
       <xsl:text>COMPRESS </xsl:text>
       <xsl:value-of select="MVIEW_TAB/NUMKEYCOLS"/>
       <xsl:text> </xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>NOCOMPRESS </xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="(MVIEW_TAB/PROPERTY2 mod 2)=1">
      <!-- CUBE table -->
      <xsl:call-template name="GenCubeTableClauses">
        <xsl:with-param name="CubeTab" select="MVIEW_TAB/CUBETAB"/>
        <xsl:with-param name="PrettyCR">0</xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <!-- heap table -->
     <xsl:text> ORGANIZATION HEAP </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="(MVIEW/FLAG mod 262144) >= 131072">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> ON PREBUILT TABLE</xsl:text>
    <xsl:choose>
     <xsl:when test="(MVIEW/FLAG mod 524288) >= 262144">
      <xsl:text> WITH REDUCED PRECISION</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text> WITHOUT REDUCED PRECISION</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <!-- Not relevant to CUBE ORGANIZED -->
    <xsl:if test="not(MVIEW_TAB/PROPERTY2) or (MVIEW_TAB/PROPERTY2 mod 2)!=1">
      <xsl:apply-templates select="MVIEW_TAB"/>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:choose>
     <xsl:when test="(MVIEW/FLAG mod 1048576)>= 524288">
      <xsl:text> BUILD DEFERRED</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text> BUILD IMMEDIATE</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <!-- Not relevant to CUBE ORGANIZED -->
   <xsl:when test="(MVIEW_TAB/PROPERTY2 mod 2)=1"/>
   <xsl:when test="(MVIEW/FLAG2 mod 2048) >= 1024">
    <xsl:text> USING NO INDEX </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> USING INDEX </xsl:text>
    <xsl:for-each select="MVIEW_IDX_LIST/MVIEW_IDX_LIST_ITEM">
     <xsl:if test="position()=1">
      <xsl:call-template name="DoMVIndex">
      </xsl:call-template>
     </xsl:if>
    </xsl:for-each>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="MVIEW/AUTO_FAST = 'NEVER'">
    <xsl:text> NEVER REFRESH</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> REFRESH </xsl:text>
    <xsl:value-of select="MVIEW/AUTO_FAST"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="(MVIEW/FLAG mod 128) >= 64">
    <xsl:text> ON DEMAND</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> ON COMMIT</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="MVIEW/AUTO_DATE">
   <xsl:text> START WITH sysdate+</xsl:text>
   <xsl:value-of select="$START_WITH"/>
  </xsl:if>
  <xsl:if test="MVIEW/AUTO_FUN">
   <xsl:text> NEXT </xsl:text>
   <xsl:value-of select="normalize-space(MVIEW/AUTO_FUN)"/>
  </xsl:if>
  <xsl:if test="$PRETTY=1 and $EXPORT=0">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="(MVIEW/FLAG mod 64) >= 32">
    <xsl:text> WITH PRIMARY KEY</xsl:text>
   </xsl:when>
   <xsl:when test="(MVIEW/FLAG mod 32) >= 16">
    <xsl:text> WITH ROWID</xsl:text>
   </xsl:when>
  </xsl:choose>
  <!-- Not relevant to CUBE ORGANIZED -->
  <xsl:if test="(MVIEW_TAB/PROPERTY2 mod 2)!=1">
    <xsl:text> USING</xsl:text>
    <xsl:if test="(MVIEW/FLAG mod 16777216) >= 8388608">
      <xsl:text> DEFAULT MASTER ROLLBACK SEGMENT</xsl:text>
    </xsl:if>
    <xsl:if test="MVIEW/MAS_ROLL_SEG">
      <xsl:text> MASTER ROLLBACK SEGMENT </xsl:text>
      <xsl:value-of select="MVIEW/MAS_ROLL_SEG"/>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="MVIEW/LOC_ROLL_SEG">
        <xsl:text> LOCAL ROLLBACK SEGMENT </xsl:text>
        <xsl:value-of select="MVIEW/LOC_ROLL_SEG"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text> DEFAULT LOCAL ROLLBACK SEGMENT</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
    </xsl:if>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="(MVIEW/FLAG2 mod 131072)>=65536">
    <xsl:text> USING TRUSTED CONSTRAINTS</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> USING ENFORCED CONSTRAINTS</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="(MVIEW/FLAG mod 4) >= 2">
   <xsl:text> FOR UPDATE</xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="(MVIEW/FLAG mod 4194304)>= 2097152">
    <xsl:text> DISABLE QUERY REWRITE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> ENABLE QUERY REWRITE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> AS </xsl:text>
  <xsl:choose>
   <xsl:when test="MVIEW/QUERY_VCNT">
    <xsl:for-each select="MVIEW/QUERY_VCNT/QUERY_VCNT_ITEM">
     <xsl:value-of select="."/>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="MVIEW/QUERY_TXT"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="MVIEW_TAB">
  <xsl:choose>
   <xsl:when test="TABCLUSTER">
    <!-- clustered table -->
    <xsl:apply-templates select="TABCLUSTER"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="PhysicalProperties"/>
    <xsl:call-template name="TableProperties"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoMVIndex">
  <xsl:apply-templates select="PCT_FREE">
   <xsl:with-param name="ADT_type" select="'INDEX'"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="STORAGE">
   <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
   <xsl:with-param name="ObjType" select="'MVIEW'"/>
   <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="DoExpMV">
  <xsl:if test="(MVIEW/OBJFLAG mod 4) >= 2 and
                (MVIEW/OBJFLAG mod 32) >= 16">
   <xsl:text>UNDER "</xsl:text>
   <xsl:value-of select="MVIEW/PARENT_SOWNER"/>
   <xsl:text>"."</xsl:text>
   <xsl:value-of select="MVIEW/PARENT_VNAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <xsl:text> USING ("</xsl:text>
  <xsl:value-of select="MVIEW/TNAME"/>
  <xsl:choose>
   <xsl:when test="MVIEW/VERS_MAJOR>2 or 
                   (MVIEW/VERS_MAJOR=2 and MVIEW/VERS_MINOR>=3)">
    <xsl:text>", (10, '</xsl:text>
   </xsl:when>
   <xsl:when test="MVIEW/VERS_MAJOR=2 and MVIEW/VERS_MINOR=2">
    <xsl:text>", (9, '</xsl:text>
   </xsl:when>
   <xsl:when test="MVIEW/VERS_MAJOR=2 and MVIEW/VERS_MINOR=1">
    <xsl:text>", (8, '</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>", (5, '</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="MVIEW/GLOBAL_DB_NAME"/>
  <xsl:text>', </xsl:text>
  <xsl:value-of select="MVIEW/TABLES"/>
  <xsl:if test="MVIEW/VERS_MAJOR>=2 and MVIEW/VERS_MINOR>=1">
   <xsl:text>, </xsl:text>
   <xsl:value-of select="MVIEW/SYN_COUNT"/>
  </xsl:if>
  <xsl:for-each select="MVIEW/SRT_LIST/SRT_LIST_ITEM">
   <xsl:text>, </xsl:text>
   <xsl:value-of select="TABLENUM"/>
   <xsl:text>, "</xsl:text>
   <xsl:value-of select="MOWNER"/>
   <xsl:text>", "</xsl:text>
   <xsl:value-of select="MASTER"/>
   <xsl:text>", '</xsl:text>
   <xsl:value-of select="SNAPTIME"/>
   <xsl:text>', </xsl:text>
   <xsl:value-of select="MASFLAG"/>
   <xsl:text>, </xsl:text>
   <xsl:value-of select="MASOBJ_NUM"/>
   <xsl:text>, '</xsl:text>
   <xsl:value-of select="LOADERTIME"/>
   <xsl:text>', '</xsl:text>
   <xsl:value-of select="LASTSUCCES"/>
   <xsl:text>', </xsl:text>
   <xsl:choose>
    <xsl:when test="FCMASKVEC and
                      EJMASKVEC">
     <xsl:text>3</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:choose>
      <xsl:when test="FCMASKVEC">
       <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:when test="EJMASKVEC">
       <xsl:text>2</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>0</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="FCMASKVEC">
    <xsl:text>, '</xsl:text>
    <xsl:value-of select="FCMASKVEC"/>
    <xsl:text>'</xsl:text>
   </xsl:if>
   <xsl:if test="EJMASKVEC">
    <xsl:text>, '</xsl:text>
    <xsl:value-of select="EJMASKVEC"/>
    <xsl:text>'</xsl:text>
   </xsl:if>
   <xsl:text>, </xsl:text>
   <xsl:value-of select="REFSCN"/>
   <xsl:text>, </xsl:text>
   <xsl:value-of select="SUB_HANDLE"/>
   <xsl:choose>
    <xsl:when test="CHANGE_VIEW">
     <xsl:text>, "</xsl:text>
     <xsl:value-of select="CHANGE_VIEW"/>
     <xsl:text>"</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>, NULL</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="SCM_COUNT > 0">
    <xsl:text>, (</xsl:text>
    <xsl:value-of select="SCM_COUNT"/>
    <xsl:for-each select="SCM_LIST/SCM_LIST_ITEM">
     <xsl:text>, "</xsl:text>
     <xsl:value-of select="SNACOL"/>
     <xsl:text>", "</xsl:text>
     <xsl:value-of select="MASCOL"/>
     <xsl:text>", </xsl:text>
     <xsl:value-of select="MASPOS"/>
     <xsl:text>, </xsl:text>
     <xsl:value-of select="COLROLE"/>
     <xsl:text>, </xsl:text>
     <xsl:value-of select="SNAPOS"/>
    </xsl:for-each>
    <xsl:text>)</xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:text>), </xsl:text>
  <xsl:value-of select="MVIEW/FLAG"/>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEW/MASTER_VERSION"/>
  <xsl:text>, </xsl:text>
  <xsl:if test="MVIEW/LOBMASKVEC">
   <xsl:text>LOB '</xsl:text>
   <xsl:value-of select="MVIEW/LOBMASKVEC"/>
   <xsl:text>', </xsl:text>
  </xsl:if>
  <xsl:if test="MVIEW/INSTSITE = 0 and
                  (MVIEW/FLAG mod 4) >= 2">
   <xsl:text>UPDATE "</xsl:text>
   <xsl:value-of select="MVIEW/USLOG"/>
   <xsl:text>", </xsl:text>
  </xsl:if>
  <xsl:text>('</xsl:text>
  <xsl:value-of select="MVIEW/SNAPSHOT"/>
  <xsl:text>', </xsl:text>
  <xsl:value-of select="MVIEW/SNAPID"/>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEW/INSTSITE"/>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEW/FLAVOR_ID"/>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEW/RSCN"/>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEW/OBJFLAG"/>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEW/FLAG2"/>
  <xsl:if test="MVIEW/VERS_MAJOR>2 or 
                (MVIEW/VERS_MAJOR=2 and MVIEW/VERS_MINOR>=3)">
   <xsl:text>, </xsl:text>
   <xsl:value-of select="MVIEW/FLAG3"/>
  </xsl:if>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEW/STATUS"/>
  <xsl:choose>
   <xsl:when test="MVIEW/PARENT_SOWNER">
    <xsl:choose>
     <xsl:when test="MVIEW/PARENT_SOWNER = MVIEW/SOWNER">
      <xsl:text>, NULL</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>, "</xsl:text>
      <xsl:value-of select="MVIEW/PARENT_OWNER"/>
      <xsl:text>"</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>, NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="MVIEW/PARENT_VNAME">
    <xsl:text>, "</xsl:text>
    <xsl:value-of select="MVIEW/PARENT_VNAME"/>
    <xsl:text>"</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>, NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>)</xsl:text>
  <xsl:choose>
   <xsl:when test="MVIEW/MLINK">
    <xsl:text>, '</xsl:text>
    <xsl:value-of select="MVIEW/MLINK"/>
    <xsl:text>')</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>)</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="MVIEW/AUTO_FAST = 'NEVER'">
    <xsl:text> NEVER REFRESH</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> REFRESH </xsl:text>
    <xsl:value-of select="MVIEW/AUTO_FAST"/>
    <xsl:if test="(MVIEW/FLAG mod 64) >= 32">
     <xsl:text> WITH PRIMARY KEY</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="(MVIEW/FLAG mod 4) >= 2">
   <xsl:text> FOR UPDATE</xsl:text>
  </xsl:if>
  <xsl:text> AS </xsl:text>
  <xsl:choose>
   <xsl:when test="MVIEW/QUERY_VCNT">
    <xsl:for-each select="MVIEW/QUERY_VCNT/QUERY_VCNT_ITEM">
     <xsl:value-of select="."/>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="MVIEW/QUERY_TXT"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
