<?xml version="1.0"?>
<!-- 
 Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
NAME
    kumodcom.xsl
DESCRIPTION
    XSLT stylesheet for common MODIFY functions
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     10/07/09 - cm_sync: ensure OWNER_NAME2 gets remapped as well
                           as OWNER_NAME.
    htseng      02/28/07 - bug 5908340: remap ref_constraint name
    htseng      02/09/07 - bug 5865356: remap constraint name
    htseng      02/01/07 - bug 5763926: remap_table in bitmap index
    lbarton     01/26/06 - REMAP_NAME
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     07/12/04 - Lrg 1714666: don't remap typeowner SYS
    lbarton     07/30/03 - Bug 3045926: remap_schema remaps grantor
    lbarton     07/10/02 - lbarton_mdapi_modify_transform
    lbarton     06/07/02 - Created
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
 <!-- Templates -->
 <xsl:template match="@*|node()">
  <!-- *******************************************************************
 copy everything from the input file
******************************************************************** -->
  <xsl:copy>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
 </xsl:template>
 <xsl:template match="ROW">
  <!-- *******************************************************************
Template: ROW
If the user specified OBJECT_ROW to select only certain rows,
  this template screens out all rows except those selected.
  Usually nothing is specified and OBJECT_ROW1 has its default value 0.
  The default is to copy all rows to the output doc.
******************************************************************** -->
  <xsl:if test="$OBJECT_ROW1=0 or
                ($OBJECT_ROW1!=0 and position()=$OBJECT_ROW1) or
                ($OBJECT_ROW2!=0 and position()=$OBJECT_ROW2) or
                ($OBJECT_ROW3!=0 and position()=$OBJECT_ROW3) or
                ($OBJECT_ROW4!=0 and position()=$OBJECT_ROW4) or
                ($OBJECT_ROW5!=0 and position()=$OBJECT_ROW5) or
                ($OBJECT_ROW6!=0 and position()=$OBJECT_ROW6) or
                ($OBJECT_ROW7!=0 and position()=$OBJECT_ROW7) or
                ($OBJECT_ROW8!=0 and position()=$OBJECT_ROW8) or
                ($OBJECT_ROW9!=0 and position()=$OBJECT_ROW9) or
                ($OBJECT_ROW10!=0 and position()=$OBJECT_ROW10)">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TYPEMD/SCHEMA_OBJ/OWNER_NAME | TYPEMD/OWNER_NAME">
  <!-- *******************************************************************
Template: OWNER_NAME for type metadata
This template does NOT remap typeowner SYS
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='SYS'">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="RemapSchema">
     <xsl:with-param name="Val" select="."/>
     <xsl:with-param name="Elem" select="name()"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="OWNER_NAME | OWNER_NAME2 | GRANTEE | GRANTOR | IMPSCHEMA | PFSCHMA | INDTYPE_OWNER">
  <!-- *******************************************************************
Template: OWNER_NAME | OWNER_NAME2 - remap the owner name elements
******************************************************************** -->
  <xsl:call-template name="RemapSchema">
   <xsl:with-param name="Val" select="."/>
   <xsl:with-param name="Elem" select="name()"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="SCHEMA_OBJ/NAME | BASE_OBJ/NAME | SYNONYM_T/NAME | ROLLBACK_T/NAME | JIJOIN_TABS_ITEM/NAME | CONSTRAINT_T/CON0/NAME | CONSTRAINT_T/CON1/NAME | REF_CONSTRAINT_T/CON2/NAME">
  <!-- *******************************************************************
Template: SCHEMA_OBJ/NAME |BASE_OBJ/NAME - remap object/base object name
       SYNONYM_T/NAME - object denoted by the synonym
       TABLESPACE_T/NAME - tablespace name
       ROLLBACK_T/NAME - rollback segment name
       JIJOIN_TABS_ITEM/NAME - bitmap join index 
       CONSTRAINT_T/CON0/NAME - constraint name
       CONSTRAINT_T/CON1/NAME - constraint name
       REF_CONSTRAINT_T/CON2/NAME - ref constraint name

******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="RemapName">
     <xsl:with-param name="Val" select="."/>
     <xsl:with-param name="Elem" select="name()"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="LONG_NAME | MVIEW/VNAME |MVIEWLOG/MASTER | SYN_LONG_NAME | OBJ_LONG_NAME ">
  <!-- *******************************************************************
Template: LONG_NAME - remap object longname
******************************************************************** -->
  <xsl:call-template name="RemapName">
   <xsl:with-param name="Val" select="."/>
   <xsl:with-param name="Elem" select="name()"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="RemapSchema">
  <xsl:param name="Val"/>
  <xsl:param name="Elem"/>
  <!-- *******************************************************************
Template: RemapSchema - common remap schema template
Parameters:
  Val  = current owner name value
  Elem = element node to remap (e.g., OWNER_NAME, OWNER_NAME2, etc.)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO1">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO2">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO3">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO4">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO5">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO6">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO7">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO8">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO9">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO10">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="RemapName">
  <xsl:param name="Val"/>
  <xsl:param name="Elem"/>
  <!-- *******************************************************************
Template: RemapName - common remap name template
Parameters:
  Val  = current owner name value
  Elem = element node to remap (e.g., LONG_NAME, OBJ_LONG_NAMEetc.)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Val=$REMAP_NAMEO1">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO2">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO3">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO4">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO5">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO6">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO7">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO8">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO9">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_NAMEO10">
    <xsl:element name="{$Elem}">
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
