<?xml version="1.0"?>
<!-- 
NAME
    kujvsrc.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_java_source_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarto	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	08/02/02 - add grantee parse param
    htseng	07/26/02 - add more parse params
    htseng	03/01/02 - .
    htseng	12/12/01 - add $EXPORT selection.
    htseng	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	09/18/01 - add syn_long_name.
    htseng	07/30/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kujava.xsl"/>
 <xsl:import href="kucolumn.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="JAVASRC_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">
    <xsl:choose>
     <xsl:when test="$EXPORT=0">CREATE</xsl:when>
     <xsl:otherwise>DBMS_JAVA.START_IMPORT</xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="ObjectType">JAVA_SOURCE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode">
    <xsl:choose>
     <xsl:when test="LONG_NAME">
      <xsl:value-of select="LONG_NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="$EXPORT=0">
    <xsl:text> CREATE JAVA SOURCE NAMED </xsl:text>
    <xsl:choose>
     <xsl:when test="LONG_NAME">
      <xsl:text>"</xsl:text>
      <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
      <xsl:text>"."</xsl:text>
      <xsl:value-of select="LONG_NAME"/>
      <xsl:text>" </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="SCHEMA_OBJ"/>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:text>AS </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="SOURCE_LINES"/>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>&#xa;</xsl:text>
     <xsl:text>/</xsl:text>
    </xsl:if>
   </xsl:when>
   <!--$EXPORT=0 -->
   <xsl:otherwise>
    <xsl:call-template name="JAVA_EXPORT_INFO"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="SOURCE_LINES">
  <xsl:for-each select="SOURCE_LINES_ITEM">
   <xsl:call-template name="Trim_string">
    <xsl:with-param name="String" select="SOURCE"/>
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
