<?xml version="1.0"?>
<!-- 
NAME
    kujava.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_java_resource_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
   lbarton      11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
   lbarton      12/16/03 - Bug 3317736: call dbms_java in separate blocks 
   htseng       05/09/03 - add begin/end block when returns NULL value
   htseng       04/29/03 - add check return STATUS value
   htseng       04/23/03 - bug 2922296
   htseng       08/02/02 - add grantee parse param
   htseng       07/26/02 - add more parse params
   htseng       03/27/02 - htseng_java_object_support
   htseng	12/10/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="JAVACLASS_T | JAVARESRC_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_JAVA.START_IMPORT</xsl:with-param>
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='JAVACLASS_T'">JAVA_CLASS</xsl:when>
     <xsl:when test="local-name(.)='JAVARESRC_T'">JAVA_RESOURCE</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:call-template name="JAVA_EXPORT_INFO"/>
 </xsl:template>
 <xsl:template name="JAVA_EXPORT_INFO">
  <xsl:choose>
   <xsl:when test="JAVA_RESOURCE">
    <xsl:call-template name="DeclareStatusBegin"/>
    <xsl:text>  STATUS := DBMS_JAVA.START_IMPORT(</xsl:text>
    <xsl:choose>
     <xsl:when test="LONG_NAME">
      <xsl:text>'</xsl:text>
      <xsl:value-of select="LONG_NAME"/>
      <xsl:text>', </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>'</xsl:text>
      <xsl:value-of select="SCHEMA_OBJ/NAME"/>
      <xsl:text>', </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="JAVA_RESOURCE/FLAGS"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="JAVA_RESOURCE/TYPE_NUM"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="JAVA_RESOURCE/PROPERTIES"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="JAVA_RESOURCE/RAW_CHUNK_COUNT"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="JAVA_RESOURCE/TOTAL_RAW_BYTE_COUNT"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="JAVA_RESOURCE/TEXT_CHUNK_COUNT"/>
    <xsl:text>);</xsl:text>
    <xsl:call-template name="JAVA_EXCEPTION"/>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>END;
</xsl:text>
    <xsl:call-template name="TEXT_CHUNK"/>
    <xsl:call-template name="RAW_CHUNK"/>
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_JAVA.END_IMPORT</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="DeclareStatusBegin"/>
    <xsl:text>  STATUS := DBMS_JAVA.END_IMPORT();</xsl:text>
    <xsl:call-template name="JAVA_EXCEPTION"/>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>BEGIN NULL; END;</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>/</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="RAW_CHUNK">
  <xsl:for-each select="JAVA_RESOURCE/RAW_CHUNK/RAW_CHUNK_ITEM">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_JAVA.IMPORT_RAW_CHUNK</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="DeclareStatusBegin"/>
   <xsl:text>  STATUS := DBMS_JAVA.IMPORT_RAW_CHUNK(HEXTORAW('</xsl:text>
   <xsl:value-of select="TEXT"/>
   <xsl:text>'), </xsl:text>
   <xsl:value-of select="LENGTH"/>
   <xsl:text>);</xsl:text>
   <xsl:call-template name="JAVA_EXCEPTION"/>
   <xsl:text> END;
</xsl:text>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="TEXT_CHUNK">
  <xsl:for-each select="JAVA_RESOURCE/TEXT_CHUNK/TEXT_CHUNK_ITEM">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_JAVA.IMPORT_TEXT_CHUNK</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="DeclareStatusBegin"/>
   <xsl:text>  STATUS := DBMS_JAVA.IMPORT_TEXT_CHUNK('</xsl:text>
   <xsl:value-of select="TEXT"/>
   <xsl:text>', </xsl:text>
   <xsl:value-of select="LENGTH"/>
   <xsl:text>);</xsl:text>
   <xsl:call-template name="JAVA_EXCEPTION"/>
   <xsl:text> END;
</xsl:text>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DeclareStatusBegin">
  <xsl:text>DECLARE </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>  STATUS NUMBER; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>BEGIN</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="JAVA_EXCEPTION">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>  IF STATUS !=0 THEN </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>    IF STATUS > 0 THEN STATUS := -STATUS; END IF; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>    execute immediate </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>    'declare an exception; pragma exception_init(an, '</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>    || status || '); ' || 'begin raise an; end;'; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>  END IF; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
