<?xml version="1.0" ?>
<!-- 
NAME
    cmkuuser.xsl
DESCRIPTION
    Convert mdapi USER_T document to CMXML USER document
    Remove elements that do not need comparing	

MODIFIED        MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    abodge      11/23/04 - Augment to handle PUBLIC role as User 
    xshen       09/20/04 - add encrypted param
    abodge      07/27/04 - Add def cons group 
    abodge      07/14/04 - abodge_add_role_etc
    abodge      07/13/04 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
 <xsl:for-each select="ROW">
  <xsl:apply-templates/>
 </xsl:for-each>
</xsl:template>

<xsl:template match="USER_T">
  <USER>
    <NAME>
      <xsl:value-of select="NAME"/>
    </NAME>
    <DEFAULT_TS>
      <xsl:value-of select="DATATS"/>
    </DEFAULT_TS>
    <TEMP_TS>
      <xsl:value-of select="TEMPTS"/>
    </TEMP_TS>
    <PROFILE>
      <xsl:value-of select="PROFNAME"/>
    </PROFILE>
    <DEF_CONS_GROUP>
      <xsl:value-of select="DEFSCHCLASS"/>
    </DEF_CONS_GROUP>

    <!-- For security -->
    <xsl:apply-templates select="PASSWORD"/> 

    <PASSWORD_STATUS>
      <xsl:choose> 
        <xsl:when test="(ASTATUS mod 4)> 0">
          <xsl:text>EXPIRED</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>UNEXPIRED</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </PASSWORD_STATUS>
    <ACCOUNT_STATUS>
      <xsl:choose> 
        <xsl:when test="ASTATUS >= 4">
          <xsl:text>LOCKED</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>UNLOCKED</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </ACCOUNT_STATUS>
    <xsl:choose>
      <xsl:when test="EXT_USERNAME">
        <GLOBAL_NAME>
          <xsl:value-of select="EXT_USERNAME"/>
        </GLOBAL_NAME>
      </xsl:when>
    </xsl:choose>
  </USER>
</xsl:template>

<!-- Treat Role PUBLIC as a USER -->

<xsl:template match="ROLE_T">
  <USER>
    <NAME>
      <xsl:value-of select="NAME"/>
    </NAME>
  </USER>
</xsl:template>

</xsl:stylesheet>
