<?xml version="1.0" ?>
<!--
NAME
    cmkutrig.xsl
DESCRIPTION
    Convert mdapi TRIGGER_T document to TRIGGER document (editable XML)

MODIFIED    MM/DD/YY
    abodge      10/27/08 - Eliminate DEFINITION node
    pkaliren    05/15/08 - Merge 11GC functionality
    lhan        04/21/05 - fix SCHEMA trigger, DATABASE trigger, etc.
    lhan        04/19/05 - replace NONE with empty string
    xshen       03/08/05 - fix schema mapping 
    xshen       03/08/05 - fix schema mapping on base object 
    ngade       09/08/04 - fix optional parameters
    abodge      09/02/04 - Do schema-mapping stuff 
    xshen       08/02/04 - remove unused attr 
    ngade       07/26/04 - remove unused template
    xshen       07/20/04 - reorder for differ
    ngade       07/10/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="TRIGGER_T">
  <TRIGGER>
    <!-- schemaName -->
    <xsl:call-template name="DoSchemaWithMapping">
     <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
    </xsl:call-template>

    <!-- name -->
    <NAME>
      <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    </NAME> 

    <xsl:choose>    
      <xsl:when test="(PROPERTY mod 64) >= 8 and (PROPERTY mod 64) &lt; 16">
        <OBJECT_TYPE>
          <xsl:text>DATABASE</xsl:text>
        </OBJECT_TYPE>  
      </xsl:when>   
      <xsl:when test="(PROPERTY mod 64) >= 16 and (PROPERTY mod 64) &lt; 32">
        <OBJECT_TYPE>
          <xsl:text>SCHEMA</xsl:text>
        </OBJECT_TYPE>
      </xsl:when>   
      <xsl:otherwise>          
        <xsl:choose>
          <xsl:when test="BASE_OBJ">
            <!-- onSchema --> 
            <OBJECT_NAME>
              <xsl:value-of select="BASE_OBJ/NAME"/>
            </OBJECT_NAME>
            <!-- onObject -->
            <OBJECT_OWNER>
             <xsl:choose>
               <xsl:when test="$SCHEMA_MAP=1 and (BASE_OBJ/OWNER_NAME=$R_SCHEMA)">
                 <xsl:value-of select="$L_SCHEMA"/>
               </xsl:when>
               <xsl:otherwise>
                 <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
               </xsl:otherwise>
             </xsl:choose>
            </OBJECT_OWNER>
            <!-- For diff (ddl as well): does not need objectType, might want to parameterize this and enable for emo objects. -->
            <xsl:choose>
              <xsl:when test="BASE_OBJ/TYPE_NAME">
                <OBJECT_TYPE>
                  <xsl:value-of select="BASE_OBJ/TYPE_NAME"/>
                </OBJECT_TYPE>  
              </xsl:when>
              <xsl:otherwise>
                <OBJECT_TYPE>
                  <xsl:value-of select="$UNAVAILABLE"/>
                </OBJECT_TYPE>  
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>  <!-- 9i if database/schema trigger have none of above -->
            <OBJECT_TYPE>
              <xsl:value-of select="$UNAVAILABLE"/>
            </OBJECT_TYPE>
          </xsl:otherwise>
        </xsl:choose>

      </xsl:otherwise>
    </xsl:choose>

    <!-- BEFORE, AFTER, INSTEAD OF -->
    <TRIGGER_TYPE>
      <xsl:choose>
        <xsl:when test="TYPE_NUM=0 or TYPE_NUM=1">
          <xsl:text>BEFORE</xsl:text>
        </xsl:when>
        <xsl:when test="TYPE_NUM=2 or TYPE_NUM=3">
          <xsl:text>AFTER</xsl:text>
        </xsl:when>
        <xsl:when test="TYPE_NUM=4">
          <xsl:text>INSTEAD OF</xsl:text>
        </xsl:when>
      </xsl:choose>
    </TRIGGER_TYPE>

    <!-- action --> 
    <xsl:choose>
      <xsl:when test="ACT_UPDATE=1 or ACT_DELETE=1 or ACT_INSERT=1">
        <ACTION>       
          <xsl:if test="ACT_INSERT=1">
              <xsl:text>INSERT</xsl:text>
          </xsl:if>
          <xsl:if test="ACT_DELETE=1">
            <xsl:choose>
              <xsl:when test="ACT_INSERT=1">
                <xsl:text> OR DELETE</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>DELETE</xsl:text>
              </xsl:otherwise>   
            </xsl:choose>  
          </xsl:if>
          <xsl:if test="ACT_UPDATE=1">
            <xsl:choose>
              <xsl:when test= "ACT_INSERT=1 or ACT_DELETE=1">
                <xsl:text> OR UPDATE</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>UPDATE</xsl:text>
              </xsl:otherwise>                                  
            </xsl:choose>  
          </xsl:if>
        </ACTION>              
      </xsl:when>
    </xsl:choose>          

    <!-- definition: should switch parsed_def which does not exist in 9i.  -->
    <!-- TBD: REGEN_DEFN  -->
    <!-- Oct. '08: NO LONGER EMITTING DEFINITION. It apparently contains no 
         information not contained elsewhere in the CMXML, and it causes
         false diffs.
    <xsl:choose>
      <xsl:when test="PARSED_DEF"> 
        <DEFINITION>
          <xsl:value-of select="substring(PARSED_DEF/SOURCE,PARSED_DEF/POST_NAME_OFF)"/>
        </DEFINITION>  
      </xsl:when>
      <xsl:otherwise>
        <DEFINITION>
          <xsl:value-of select="substring-after(DEFINITION,substring-before(normalize-space(DEFINITION),' '))"/>   
        </DEFINITION>  
      </xsl:otherwise>
    </xsl:choose>
    -->

    <!-- enabled -->
    <xsl:choose>
      <xsl:when test="ENABLED=0">
        <ENABLED>
         <xsl:text>NO</xsl:text>
        </ENABLED>
      </xsl:when>
      <xsl:otherwise>
        <ENABLED>
         <xsl:text>YES</xsl:text>
        </ENABLED>
      </xsl:otherwise>
    </xsl:choose>

    <!-- forEachRow -->
    <xsl:choose>
      <xsl:when test="TYPE_NUM=1 or TYPE_NUM=3">
        <FOR_EACH_ROW>
          <xsl:text>YES</xsl:text>            
        </FOR_EACH_ROW>
      </xsl:when>
      <xsl:otherwise>
        <FOR_EACH_ROW>
          <xsl:text>NO</xsl:text>            
        </FOR_EACH_ROW>
      </xsl:otherwise>
    </xsl:choose>

    <!-- triggerBody: mdapi bug?? sometimes no body present in mdapi xmls -->
    <TRIGGER_BODY>
      <xsl:choose>
        <xsl:when test="BODY">
          <xsl:value-of select="BODY"/>   
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$UNAVAILABLE"/>   
        </xsl:otherwise>
      </xsl:choose>
    </TRIGGER_BODY>   

    <!-- Reference name: not in 9i mdapi  -->
    <!-- newRef -->
    <xsl:choose>
      <xsl:when test="REFNEWNAME">
        <NEW_REFERENCE>
          <xsl:value-of select="REFNEWNAME"/>   
        </NEW_REFERENCE> 
      </xsl:when>
      <xsl:otherwise>
       <NEW_REFERENCE>
        <xsl:value-of select="$UNAVAILABLE"/>   
       </NEW_REFERENCE>
      </xsl:otherwise>
    </xsl:choose>
    <!-- oldRef -->
    <xsl:choose>
      <xsl:when test="REFOLDNAME">
       <OLD_REFERENCE>
        <xsl:value-of select="REFOLDNAME"/>   
       </OLD_REFERENCE>
      </xsl:when>
      <xsl:otherwise>
       <OLD_REFERENCE>
        <xsl:value-of select="$UNAVAILABLE"/>   
       </OLD_REFERENCE>
      </xsl:otherwise>
    </xsl:choose>


    <!-- MDAPI 92 no cols.  columns -->
    <xsl:choose>
      <!-- 10g always has cols even if empty COLS -->
      <xsl:when test="COLS">
       <xsl:choose>
         <xsl:when test="COLS/COLS_ITEM[TYPE_NUM=0]">
           <COL_LIST>
             <xsl:for-each select="COLS/COLS_ITEM[TYPE_NUM=0]">
               <xsl:sort select="NAME"/>
               <xsl:if test="position()!=1">
                 <xsl:text>,</xsl:text>
               </xsl:if>
               <xsl:value-of select="current()/NAME"/>
               <xsl:if test="position()=last()">
                 <xsl:text></xsl:text>
               </xsl:if>
             </xsl:for-each>
            </COL_LIST>  
          </xsl:when>
          <xsl:otherwise>
            <COL_LIST>
              <xsl:text></xsl:text>
            </COL_LIST>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 92 or lower: use unavailable .-->
      <xsl:otherwise>
        <COL_LIST>
          <xsl:value-of select="$UNAVAILABLE"/>
        </COL_LIST>
      </xsl:otherwise>
    </xsl:choose>

    <!-- Optional: condition -->
    <xsl:choose>
      <xsl:when test="WHENCLAUSE">
        <CONDITION>
          <xsl:value-of select="WHENCLAUSE"/>
        </CONDITION>
      </xsl:when>
    </xsl:choose>

  </TRIGGER>
</xsl:template>

 <xsl:template name="database_event_clause">
  <!-- TBD -->
 </xsl:template>

 <xsl:template name="ddl_event_clause">
  <!-- TBD -->
 </xsl:template>

 <xsl:template name="dml_event_clause">
  <xsl:if test="ACT_INSERT!=0">
   <xsl:text>INSERT </xsl:text>
   <xsl:if test="ACT_DELETE!=0 or ACT_UPDATE!=0">
    <xsl:text>OR </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="ACT_DELETE!=0">
   <xsl:text>DELETE </xsl:text>
   <xsl:if test="ACT_UPDATE!=0">
    <xsl:text>OR </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="ACT_UPDATE!=0">
   <xsl:text>UPDATE </xsl:text>
  </xsl:if>

 </xsl:template>
</xsl:stylesheet>
