<?xml version="1.0" ?>
<!-- 
NAME
    cmkuprofil.xsl
DESCRIPTION
    Convert mdapi PROFILE_T document to CMXML PROFILE document
    Remove elements that do not need comparing	

MODIFIED	MM/DD/YY
    pkalire 05/15/08 - Merge 11GC functionality
    ngade   08/23/04 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
 <xsl:for-each select="ROW">
  <xsl:apply-templates/>
 </xsl:for-each>
</xsl:template>

<xsl:template match="PROFILE_LIST">
 <PROFILE_LIST>
 <xsl:for-each select="PROFILE_LIST_ITEM">
   <xsl:sort select="RESNAME"/>
   <PROFILE_LIST_ITEM  NAME="{RESNAME}">
     <xsl:if test="TYPE_NUM=0">
       <NAME>
         <xsl:value-of select="RESNAME"/>
       </NAME>
         <xsl:call-template name="LIMIT_INFO"/>
     </xsl:if>
     <xsl:if test="TYPE_NUM=1">
       <xsl:if test="RESOURCE_NUM !=4">
       <NAME>
         <xsl:value-of select="RESNAME"/>
       </NAME>
         <xsl:call-template name="LIMIT_INFO"/>
       </xsl:if>
     </xsl:if>
   </PROFILE_LIST_ITEM>
  </xsl:for-each>
 </PROFILE_LIST>
</xsl:template>

<xsl:template name="LIMIT_INFO">
  <xsl:choose>
    <xsl:when test="LIMIT_NUM=2147483647">
      <VALUE>
        <xsl:text>UNLIMITED</xsl:text>
      </VALUE>
    </xsl:when>
    <xsl:when test="LIMIT_NUM=0">
      <VALUE>
      <xsl:text>DEFAULT</xsl:text>
      </VALUE>
    </xsl:when>
    <xsl:otherwise>
      <xsl:if test="LIMIT_NUM">
        <xsl:choose>
          <xsl:when test="TYPE_NUM=1 and (RESOURCE_NUM =1 or RESOURCE_NUM =2 or RESOURCE_NUM =5 or RESOURCE_NUM =6)">
            <VALUE>
              <xsl:value-of select="LIMIT_NUM div 86400" />
            </VALUE>
          </xsl:when>
          <xsl:otherwise>
            <VALUE>
              <xsl:value-of select="LIMIT_NUM" />
            </VALUE>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>



<xsl:template match="PROFILE_T">
  <PROFILE>
    <NAME>
      <xsl:value-of select="PROFILE_NAME"/>
    </NAME>
    <xsl:apply-templates select="PROFILE_LIST"/>
    <xsl:if test="string-length(PASS_FUNC_NAME) != 0">
      <PASS_FUNC_NAME>
        <xsl:value-of select="PASS_FUNC_NAME" /> 
      </PASS_FUNC_NAME>
    </xsl:if>
  </PROFILE>
</xsl:template>

</xsl:stylesheet>
