<?xml version="1.0" ?>
<!--
NAME
    cmkumview.xsl
DESCRIPTION
    Convert mdapi materialized-view document to editable XML

MODIFIED    MM/DD/YY
    pkaliren     05/15/08 - Merge 11GC functionality
    abodge       01/02/07 - Correct mview schema
    xshen        03/08/05 - fix schema mapping 
    abodge       08/27/04 - abodge_mviews
    abodge       08/27/04 - Adjustments
    abodge       08/18/04 - Add more stuff 
    abodge       08/16/04 - Continue development 
    abodge       08/09/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkustorage.xsl"/>
<xsl:import href="cmkutable.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="M_VIEW_T">
<xsl:element name = "MATERIALIZED_VIEW">
    <xsl:call-template name="DoSchemaWithMapping">
     <xsl:with-param name="CurrentSchema" select="MVIEW/SOWNER"/>
    </xsl:call-template>
 <xsl:element name = "NAME">
  <xsl:value-of select="MVIEW/VNAME"/>
 </xsl:element>

 <xsl:element name = "MASTER_OWNER">
             <xsl:choose>
               <xsl:when test="$SCHEMA_MAP=1 and (MVIEW/MOWNER=$R_SCHEMA)">
                 <xsl:value-of select="$L_SCHEMA"/>
               </xsl:when>
               <xsl:otherwise>
                 <xsl:value-of select="MVIEW/MOWNER"/>
               </xsl:otherwise>
             </xsl:choose>
 </xsl:element>

 <xsl:element name = "MASTER_NAME">
  <xsl:value-of select="MVIEW/MASTER"/>
 </xsl:element>

 <xsl:if test = "MVIEW/MLINK">
  <xsl:element name = "MASTER_LINK">
   <xsl:value-of select = "MVIEW/MLINK"/>
  </xsl:element>
 </xsl:if>
 
 <xsl:if test="(MVIEW/OBJFLAG mod 4) >= 2">
  <xsl:element name = "OF_TYPE_OWNER">
   <xsl:value-of select ="MVIEW/SNA_TYPE_OWNER"/>
  </xsl:element>
  <xsl:element name = "OF_TYPE_NAME">
   <xsl:value-of select ="MVIEW/SNA_TYPE_NAME"/>
  </xsl:element>
 </xsl:if>
 
 <!-- NOT NEEDED, included in PHYSICAL_PROPERTIES
 <xsl:if test="(MVIEW/FLAG mod 262144) &lt; 131072">
  <xsl:if test = "(MVIEW/FLAG mod 67108865) >= 33554432">
   <INDEX_ORGANIZATION>
    <xsl:if test = "MVIEW_TAB/NUMKEYCOLS > 0">
     <COMPRESS>
       <xsl:value-of select = "MVIEW_TAB/NUMKEYCOLS"/>
     </COMPRESS>
    </xsl:if>
   </INDEX_ORGANIZATION>
  </xsl:if>
 </xsl:if>
 -->

 <xsl:choose>
  <xsl:when test="(MVIEW/FLAG mod 262144) >= 131072">
   <!-- prebuilt_table_clause -->
   <xsl:element name = "PREBUILT_TABLE">
    <xsl:element name = "REDUCED_PRECISION">
     <xsl:choose>
      <xsl:when test="(MVIEW/FLAG mod 524288) >= 262144">
       <xsl:text>Y</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>N</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:element>
  </xsl:when>
  <xsl:otherwise>
   <!-- materialized_view_props -->
   <xsl:element name = "MATERIALIZED_VIEW_PROPERTIES">
    <!-- SEGMENT_ATTRIBUTES generated later
    <xsl:call-template name="DoSegmentAttributes">
     <xsl:with-param name="ParentNode" select="MVIEW_TAB"/>
    </xsl:call-template>
    -->
    <xsl:element name = "CACHE">
     <xsl:choose>
      <xsl:when test = "(MVIEW_TAB/FLAGS mod 16) >= 8">
       <xsl:text>Y</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>N</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
 
    <!-- TODO? column_properties -->
    <xsl:element name = "BUILD">
     <xsl:choose>
      <xsl:when test="(MVIEW/FLAG mod 1048576)>= 524288">
       <xsl:text>DEFERRED</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>IMMEDIATE</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
    <xsl:if test = "MVIEW_TAB/DEGREE">
     <xsl:element name = "PARALLEL_DEGREE">
      <xsl:choose>
       <xsl:when test = "MVIEW_TAB/DEGREE = 32767">
        <xsl:text>DEFAULT</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select = "MVIEW_TAB/DEGREE"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:otherwise>
 </xsl:choose>

 <xsl:if test = "(MVIEW/FLAG2 mod 2048) &lt; 1024">
  <xsl:element name = "USING_INDEX">
   <xsl:for-each select="MVIEW_IDX_LIST/MVIEW_IDX_LIST_ITEM">
    <xsl:if test="position()=1">
     <xsl:call-template name="DoSchemaWithMapping">
      <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
     </xsl:call-template>
     <xsl:element name = "NAME">
      <xsl:value-of select = "SCHEMA_OBJ/NAME"/>
     </xsl:element>
     <xsl:call-template name="DoSegmentAttributes">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
    </xsl:if> 
   </xsl:for-each>
  </xsl:element>
 </xsl:if>
 
 <xsl:element name = "REFRESH">
  <xsl:if test="MVIEW/AUTO_FAST != 'NEVER'">
   <xsl:element name = "REFRESH_TYPE">
   <!--
 	FORCE
 	FAST
 	COMPLETE
   -->
    <xsl:value-of select="MVIEW/AUTO_FAST"/>
   </xsl:element>
  </xsl:if>
 
  <xsl:element name = "REFRESH_INTERVAL">
  <!--
 	ON_DEMAND
 	ON_COMMIT
 	AUTO
 	NEVER
  -->
   <xsl:choose>
    <xsl:when test="MVIEW/AUTO_FAST = 'NEVER'">
     <xsl:text>NEVER</xsl:text>
    </xsl:when>
    <xsl:when test="MVIEW/AUTO_DATE">
     <xsl:text>AUTO</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:choose>
      <xsl:when test="(MVIEW/FLAG mod 128) >= 64">
       <xsl:text>ON_DEMAND</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>ON_COMMIT</xsl:text>
      </xsl:otherwise>
     </xsl:choose>   
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 
  <xsl:if test="MVIEW/AUTO_FUN">
   <!-- It is not clear exactly what we're getting from MDAPI here... -->
   <xsl:element name = "REFRESH_DATE">
    <xsl:value-of select="normalize-space(MVIEW/AUTO_FUN)"/>
   </xsl:element>
  </xsl:if>
 
  <xsl:element name = "REFRESH_METHOD">
   <xsl:choose>
    <xsl:when test="(MVIEW/FLAG mod 64) >= 32">
     <xsl:text>PRIMARY_KEY</xsl:text>
    </xsl:when>
    <xsl:when test="(MVIEW/FLAG mod 32) >= 16">
     <xsl:text>ROWID</xsl:text>
    </xsl:when>
   </xsl:choose>
  </xsl:element>
 
  <xsl:if test="(MVIEW/FLAG mod 16777216) >= 8388608">
   <xsl:element name = "MASTER_RBS">
    <xsl:element name = "DEFAULT">
     <xsl:text>Y</xsl:text>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 
  <xsl:if test="MVIEW/MAS_ROLL_SEG">
   <xsl:element name = "MASTER_RBS">
    <xsl:element name = "DEFAULT">
     <xsl:text>N</xsl:text>
    </xsl:element>
    <xsl:element name = "SEG_NAME">
     <xsl:value-of select="MVIEW/MAS_ROLL_SEG"/>
    </xsl:element>
   </xsl:element>
  </xsl:if>

  <xsl:element name = "LOCAL_RBS">
   <xsl:element name = "DEFAULT">
    <xsl:choose>
     <xsl:when test="MVIEW/LOC_ROLL_SEG">
      <xsl:text>N</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>Y</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:if test="MVIEW/LOC_ROLL_SEG">
    <xsl:element name = "SEG_NAME">
     <xsl:value-of select="MVIEW/LOC_ROLL_SEG"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:element>
 
 <xsl:element name = "FOR_UPDATE">
  <xsl:choose>
   <xsl:when test = "(MVIEW/FLAG mod 4) >= 2">
    <xsl:text>Y</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>N</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:element>
 
 <xsl:element name = "QUERY_REWRITE">
  <xsl:choose>
   <xsl:when test="(MVIEW/FLAG mod 4194304)>= 2097152">
    <xsl:text>DISABLE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>ENABLE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:element>
 
 <xsl:element name = "QUERY">
  <xsl:choose>
   <xsl:when test="MVIEW/QUERY_VCNT">
    <xsl:for-each select="MVIEW/QUERY_VCNT/QUERY_VCNT_ITEM">
     <xsl:value-of select="."/>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="MVIEW/QUERY_TXT"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:element>

 <!--  Handles IOT stuff, clustered table  -->
 <xsl:choose>
  <xsl:when test="TABCLUSTER">                        
   <xsl:apply-templates select="MVIEW_TAB/TABCLUSTER"/>
  </xsl:when>
  <xsl:otherwise>
   <xsl:apply-templates select = "MVIEW_TAB"/>
  </xsl:otherwise>
 </xsl:choose>
 
 <xsl:element name="MVIEW_TABLE_PROPERTIES">
  <xsl:if test="(MVIEW_TAB/PROPERTY mod 64)>=32">
   <xsl:choose>
    <xsl:when test="MVIEW_TAB/PART_OBJ/PARTOBJ/PARTTYPE=1">
     <xsl:element name="RANGE_PARTITIONING">
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PARTCOLS"/>
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PARTOBJ"/>
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PART_LIST"/>
     </xsl:element>
    </xsl:when>
    <xsl:when test="MVIEW_TAB/PART_OBJ/PARTOBJ/PARTTYPE=2">
     <xsl:element name="HASH_PARTITIONING">
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PARTCOLS"/>
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PARTOBJ"/>
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PART_LIST"/>
     </xsl:element>
    </xsl:when>
    <xsl:when test="MVIEW_TAB/PART_OBJ/PARTOBJ/PARTTYPE=4">
     <xsl:element name="LIST_PARTITIONING">
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PARTCOLS"/>
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PARTOBJ"/>
      <xsl:apply-templates select="MVIEW_TAB/PART_OBJ/PART_LIST"/>
     </xsl:element>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
 </xsl:element>

 
</xsl:element>

</xsl:template>

<xsl:template match = "MVIEW_TAB">
 <xsl:call-template name="GenTablePhysicalProps"/>
</xsl:template>

</xsl:stylesheet>
