<?xml version="1.0" ?>
<!--
NAME
    cmkuseq.xsl
DESCRIPTION
    Convert mdapi DBLINK_T document to DBLINK document (editable XML)

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       03/08/05 - fix schema mapping 
    ngade       10/26/04 - 
    abodge      09/02/04 - Add schema mapping magic 
    lhan        08/19/04 - lhan_cm_0819
    lhan        08/19/04 - creation
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="DBLINK_T">
<DBLINK>

  <xsl:call-template name="DoSchemaWithMapping">
   <xsl:with-param name="CurrentSchema" select="OWNER_NAME"/>
  </xsl:call-template>

  <NAME>
   <xsl:value-of select="NAME"/>
  </NAME>

 <!-- Determine if SHARED or not -->
 <xsl:element name="SHARED">
  <xsl:choose>
    <xsl:when test = "FLAG = 1">
     <xsl:text>Y</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>N</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
 </xsl:element> 

 <!-- Determine if PUBLIC or not -->
 <xsl:element name="PUBLIC">
  <xsl:choose>
    <xsl:when test = "OWNER_NUM = 1">
     <xsl:text>Y</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>N</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
 </xsl:element> 

  <xsl:if test="HOST">
   <xsl:element name="HOST">
   <xsl:value-of select="HOST"/>
   </xsl:element>
  </xsl:if>

  <xsl:if test="USERID">
   <xsl:element name="USERID">
     <xsl:value-of select="USERID"/>
   </xsl:element> 
  </xsl:if>

</DBLINK>
</xsl:template>


</xsl:stylesheet>


