ALTER TABLE MD_FILE_ARTIFACTS DISABLE CONSTRAINT MD_ARTIFACT_FILE_FK;
ALTER TABLE MD_APPLICATIONFILES DISABLE CONSTRAINT MD_FILE_APP_FK;
ALTER TABLE MD_APPLICATIONFILES DISABLE CONSTRAINT MD_APPLICATIONFILES_PK;

TRUNCATE TABLE MD_APPLICATIONFILES;
TRUNCATE TABLE MD_FILE_ARTIFACTS;

DROP TABLE MD_APPLICATIONS CASCADE CONSTRAINTS;

CREATE TABLE MD_APPLICATIONS
  (
    ID                NUMBER NOT NULL ,
    NAME              VARCHAR2 (4000 BYTE) ,
    DESCRIPTION       VARCHAR2 (4000 BYTE) ,
    BASE_DIR          VARCHAR2 (4000 BYTE) ,
    OUTPUT_DIR        VARCHAR2 (4000 BYTE) ,
    BACKUP_DIR        VARCHAR2 (4000 BYTE) ,
    INPLACE			NUMBER,
    PROJECT_ID_FK     NUMBER NOT NULL ,
    SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
    CREATED_ON DATE DEFAULT sysdate NOT NULL ,
    CREATED_BY VARCHAR2 (255 BYTE) ,
    LAST_UPDATED_ON DATE ,
    LAST_UPDATED_BY VARCHAR2 (255 BYTE)
  ) ;
COMMENT ON TABLE MD_APPLICATIONS
IS
  'This is the base table for application projects.  It holds the base information for applications associated with a database';
  COMMENT ON COLUMN MD_APPLICATIONS.ID
IS
  'Primary Key';
  COMMENT ON COLUMN MD_APPLICATIONS.NAME
IS
  'Name of the application suite  //OBJECTNAME';
  COMMENT ON COLUMN MD_APPLICATIONS.DESCRIPTION
IS
  'Overview of what the application does.';
  COMMENT ON COLUMN MD_APPLICATIONS.BASE_DIR
IS
  'This is the base src directory for the application.  It could be an svn checkout, a clearcase view or something similar' ;
  COMMENT ON COLUMN MD_APPLICATIONS.OUTPUT_DIR
IS
  'This is the output directory where the scanner will present the converted files, if there are converted or modified.' ;
  COMMENT ON COLUMN MD_APPLICATIONS.BACKUP_DIR
IS
  'This is the directory in which the application files are backed up if a backp is chosen' ;
  COMMENT ON COLUMN MD_APPLICATIONS.INPLACE
IS
  'Designates whether the changes have been made inplace, in the source directory or not' ;
  COMMENT ON COLUMN MD_APPLICATIONS.PROJECT_ID_FK
IS
  'project of the database(s) this application relates to' ;

ALTER TABLE MD_APPLICATIONS ADD CONSTRAINT MD_APPLICATIONS_PK PRIMARY KEY
  (
    ID
  )
  ;
  
ALTER TABLE MD_APPLICATIONFILES ADD CONSTRAINT MD_FILE_APP_FK FOREIGN KEY(APPLICATIONS_ID_FK) REFERENCES MD_APPLICATIONS(ID) ON
  DELETE CASCADE NOT DEFERRABLE;
ALTER TABLE MD_APPLICATIONS ADD CONSTRAINT MD_APP_PROJ_FK FOREIGN KEY (PROJECT_ID_FK) REFERENCES MD_PROJECTS(ID) ON
  DELETE CASCADE NOT DEFERRABLE;
  
ALTER TABLE MD_APPLICATIONFILES ENABLE CONSTRAINT MD_FILE_APP_FK;
ALTER TABLE MD_APPLICATIONFILES ENABLE CONSTRAINT MD_APPLICATIONFILES_PK;
ALTER TABLE MD_FILE_ARTIFACTS ENABLE CONSTRAINT MD_ARTIFACT_FILE_FK;

CREATE OR REPLACE TRIGGER "INS_APPLICATION_TRG" BEFORE INSERT OR UPDATE ON MD_APPLICATIONS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER  TRIGGER "INS_APPLICATION_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "INS_APPLICATIONFILE_TRG" BEFORE INSERT OR UPDATE ON MD_APPLICATIONFILES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER  TRIGGER "INS_APPLICATIONFILE_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "INS_FILE_ARTIFACT_TRG" BEFORE INSERT OR UPDATE ON MD_FILE_ARTIFACTS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER  TRIGGER "INS_FILE_ARTIFACT_TRG" ENABLE;

UPDATE MD_REPOVERSIONS SET REVISION=54;
commit;