  CREATE TABLE MD_PARTITIONS
    (
      ID                            NUMBER NOT NULL ,
      TABLE_ID_FK                   NUMBER NOT NULL ,
      NATIVE_SQL                    CLOB ,
      PARTITION_EXPRESSION          VARCHAR2 (4000 BYTE) ,
      COMMENTS                      VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID             NUMBER DEFAULT 0 NOT NULL ,
      CREATED_BY                    VARCHAR2 (255 BYTE) ,
      CREATED_ON                    DATE DEFAULT sysdate NOT NULL ,
      LAST_UPDATED_BY               VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON               DATE
    ) ;
  COMMENT ON TABLE MD_PARTITIONS
IS
  'Partition information is stored in this table.' ;
  COMMENT ON COLUMN MD_PARTITIONS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_PARTITIONS.TABLE_ID_FK
IS
  'The table that this partition refers to //PARENTFIELD' ;
  COMMENT ON COLUMN MD_PARTITIONS.NATIVE_SQL
IS
  'The SQL used to create this partition at source' ;
  COMMENT ON COLUMN MD_PARTITIONS.PARTITION_EXPRESSION
IS
  'The partition expression' ;
  ALTER TABLE MD_PARTITIONS ADD CONSTRAINT MD_PARTITIONS_PK PRIMARY KEY
  (
    ID
  )
  ;

  ALTER TABLE MD_PARTITIONS ADD CONSTRAINT MD_PARTITIONS_MD_TABLES_FK1 FOREIGN KEY ( TABLE_ID_FK ) REFERENCES MD_TABLES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;

Insert into MD_REGISTRY (OBJECT_NAME,OBJECT_TYPE,DESC_OBJECT_NAME) values ('MD_PARTITIONS','TABLE','PARTITION');

UPDATE MD_REPOVERSIONS SET REVISION=35;
commit;

