-- Remove all repository objects. MD_REGISTRY needs to exist for this.
DECLARE 
  CURSOR reg_order IS SELECT * FROM md_registry;
  sql_stmt VARCHAR2(200);
  object_not_found EXCEPTION;
  table_not_found  EXCEPTION;
  sequence_not_found EXCEPTION;
  resource_busy EXCEPTION;
  pragma exception_init(object_not_found, -4043);
  pragma exception_init(table_not_found, -942);
  pragma exception_init(sequence_not_found, -2289);
  pragma exception_init(resource_busy, -54);
BEGIN
  FOR item IN reg_order
  LOOP
    BEGIN
      IF item.object_type = 'TABLE' THEN
        -- if tables have pimary keys, we need to remove them and cascade the FKs
        DECLARE con_stmt VARCHAR2(200);
        CURSOR concur IS 
          SELECT * FROM user_constraints
          WHERE TABLE_NAME = item.object_name AND constraint_type = 'P';
        BEGIN
          FOR con IN concur
          LOOP
            con_stmt := 'alter table ' || item.object_name ||
            ' drop constraint ' || con.constraint_name || ' CASCADE';
            EXECUTE IMMEDIATE con_stmt;
          END LOOP;
        END;
     END IF;
     -- Now drop the object.
     sql_stmt := 'DROP ' || item.object_type || ' ' || item.object_name;
     IF item.object_type = 'TYPE' THEN sql_stmt := sql_stmt || ' force';
     END IF;
     EXECUTE IMMEDIATE sql_stmt;
    EXCEPTION
      WHEN object_not_found THEN NULL;
      WHEN table_not_found THEN NULL;
      WHEN sequence_not_found THEN NULL;
      WHEN resource_busy THEN NULL;
     END;
  END LOOP;
    -- Ok, everything is deleted, now removed the registry table.
    DECLARE con_stmt VARCHAR2(200) := 'alter table MD_REGISTRY drop constraint ';
      CURSOR concur IS
        SELECT * FROM user_constraints
        WHERE TABLE_NAME = 'MD_REGISTRY' AND constraint_type = 'P';
    BEGIN
      FOR item IN concur
      LOOP
        con_stmt := con_stmt || item.constraint_name || ' cascade';
        EXECUTE IMMEDIATE con_stmt;
      END LOOP;
      EXECUTE IMMEDIATE 'DROP TABLE MD_REGISTRY';
     END;
EXCEPTION
  WHEN no_data_found THEN NULL;
  WHEN table_not_found THEN NULL;
END;
/

