<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2014 (x64) - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:altova="http://www.altova.com" xmlns:altovaext="http://www.altova.com/xslt-extensions" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://oracle.com/datamodeler/reports/domains" xmlns:sps="http://www.altova.com/StyleVision/user-xpath-functions" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="#all">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" use-character-maps="spaces" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
	<xsl:character-map name="spaces">
		<xsl:output-character character="&#160;" string="&amp;nbsp;"/>
	</xsl:character-map>
	<xsl:param name="altova:bGeneratingFromPxf" select="false()"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:param name="SV_BaseOutputFileName" as="xs:string?">
		<xsl:sequence select="for $i in altovaext:get-base-output-uri(), $j in tokenize( $i, &apos;[/\\]&apos; )[last()] return replace( $j, &apos;\.[^\.\s#%;]*$&apos;, &apos;&apos; )" use-when="function-available(&apos;altovaext:get-base-output-uri&apos;)"/>
	</xsl:param>
	<xsl:param name="SV_GeneratedFileNamePrefix" select="if ( $SV_BaseOutputFileName ) then $SV_BaseOutputFileName else &apos;AllDomainsDetails&apos;" as="xs:string?"/>
	<xsl:param name="p1"/>
	<xsl:param name="p2"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:variable name="altova:CssImages" select="()"/>
	<xsl:template match="/">
		<xsl:call-template name="altova:Root"/>
	</xsl:template>
	<xsl:template name="altova:Root">
		<html>
			<head>
				<title/>
				<meta name="generator" content="Altova StyleVision Enterprise Edition 2014 (x64) (http://www.altova.com)"/>
				<meta http-equiv="X-UA-Compatible" content="IE=7"/>
                <xsl:value-of select="normalize-space(concat('&lt;link rel=&quot;stylesheet&quot; type=&quot;text/css&quot; href=&quot;', $p1, '&quot;>'))" disable-output-escaping="yes"/>
                <xsl:value-of select="normalize-space(concat('&lt;link rel=&quot;stylesheet&quot; type=&quot;text/css&quot; href=&quot;', $p2, '&quot;>'))" disable-output-escaping="yes"/>
				<xsl:comment>[if IE]&gt;&lt;STYLE type=&quot;text/css&quot;&gt;.altova-rotate-left-textbox{filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3)} .altova-rotate-right-textbox{filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=1)} &lt;/STYLE&gt;&lt;![endif]</xsl:comment>
				<xsl:comment>[if !IE]&gt;&lt;!</xsl:comment>
				<style type="text/css">.altova-rotate-left-textbox{-webkit-transform: rotate(-90deg) translate(-100%, 0%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(-90deg) translate(-100%, 0%); -moz-transform-origin: 0% 0%;-ms-transform: rotate(-90deg) translate(-100%, 0%); -ms-transform-origin: 0% 0%;}.altova-rotate-right-textbox{-webkit-transform: rotate(90deg) translate(0%, -100%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(90deg) translate(0%, -100%); -moz-transform-origin: 0% 0%;-ms-transform: rotate(90deg) translate(0%, -100%); -ms-transform-origin: 0% 0%;}</style>
				<xsl:comment>&lt;![endif]</xsl:comment>
				<style type="text/css">@page { margin-left:2cm; margin-right:2cm; margin-top:2cm; margin-bottom:2cm } @media print { br.altova-page-break { page-break-before: always; } }</style>
			</head>
			<body style="font-family:Tahoma; font-size:xx-small; ">
				<xsl:for-each select="$XML">
					<xsl:for-each select="n1:Domains">
						<center>
							<xsl:for-each select="n1:ReportCaption">
								<span class="caption">
									<xsl:apply-templates/>
								</span>
							</xsl:for-each>
						</center>
						<p/>
						<xsl:variable name="altova:table">
							<table class="w_20">
								<xsl:variable name="altova:CurrContextGrid_0" select="."/>
								<xsl:variable name="altova:ColumnData"/>
								<tbody>
									<tr>
										<td class="td_h_v w_4">
											<span>
												<xsl:text>Design Name</xsl:text>
											</span>
										</td>
										<td class="td w_16">
											<xsl:for-each select="n1:DesignName">
												<xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
									<tr>
										<td class="td_h_v">
											<span>
												<xsl:text>Version Date</xsl:text>
											</span>
										</td>
										<td class="td">
											<xsl:for-each select="n1:VersionDate">
												<xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
									<tr>
										<td class="td_h_v">
											<span>
												<xsl:text>Version Comment</xsl:text>
											</span>
										</td>
										<td class="td">
											<xsl:for-each select="n1:VersionComment">
												<xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</tbody>
							</table>
						</xsl:variable>
						<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
						<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
						<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
							<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
						</xsl:apply-templates>
						<xsl:for-each select="n1:DomainsCollection">
							<xsl:for-each select="n1:DomainDetails">
								<xsl:if test="../../n1:UsePageBreaks = &apos;true&apos;">
									<br/>
									<br class="altova-page-break" clear="all"/>
								</xsl:if>
								<p/>
								<xsl:variable name="altova:table">
									<table class="w_16">
										<xsl:variable name="altova:CurrContextGrid_1" select="."/>
										<xsl:variable name="altova:ColumnData"/>
										<tbody>
											<tr>
												<td class="td_h_v w_4">
													<span>
														<xsl:text>Domain Name</xsl:text>
													</span>
												</td>
												<td class="td obj_name w_12">
													<a>
														<xsl:attribute name="name">
															<xsl:value-of select="n1:DomainName"/>
														</xsl:attribute>
														<xsl:for-each select="n1:DomainName">
															<xsl:apply-templates/>
														</xsl:for-each>
													</a>
												</td>
											</tr>
											<tr>
												<td class="td_h_v">
													<span>
														<xsl:text>Synonyms</xsl:text>
													</span>
												</td>
												<td class="td">
													<xsl:for-each select="n1:Synonyms">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr>
												<td class="td_h_v">
													<span>
														<xsl:text>Data Type</xsl:text>
													</span>
												</td>
												<td class="td">
													<xsl:for-each select="n1:DataType">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr>
												<td class="td_h_v">
													<span>
														<xsl:text>Logical Type</xsl:text>
													</span>
												</td>
												<td class="td">
													<xsl:for-each select="n1:LogicalType">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr>
												<td class="td_h_v">
													<span>
														<xsl:text>Unit Of Measure</xsl:text>
													</span>
												</td>
												<td class="td">
													<xsl:for-each select="n1:UnitOfMeasure">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr>
												<td class="td_h_v">
													<span>
														<xsl:text>Default Value</xsl:text>
													</span>
												</td>
												<td class="td">
													<xsl:for-each select="n1:DefaultValue">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
											<tr>
												<td class="td_h_v">
													<span>
														<xsl:text>Comments</xsl:text>
													</span>
												</td>
												<td class="td">
													<xsl:for-each select="n1:DomainComment">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
										</tbody>
									</table>
								</xsl:variable>
								<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
								<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
								<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
									<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
								</xsl:apply-templates>
								<xsl:if test="count( n1:ConstraintsCollection )">
									<p/>
									<span class="t_cap">
										<xsl:text>Constraints</xsl:text>
									</span>
									<xsl:variable name="altova:table">
										<table class="w_25">
											<xsl:variable name="altova:CurrContextGrid_2" select="."/>
											<xsl:variable name="altova:ColumnData"/>
											<thead>
												<tr>
													<th class="td_h_h w_25">
														<span>
															<xsl:text>Details</xsl:text>
														</span>
													</th>
												</tr>
											</thead>
											<tbody>
												<xsl:for-each select="n1:ConstraintsCollection">
													<xsl:for-each select="n1:ConstraintDetails">
														<tr>
															<td class="td">
																<xsl:if test="count( n1:RangesCollection )">
																	<br/>
																	<span class="t_cap">
																		<xsl:text>Ranges</xsl:text>
																	</span>
																	<xsl:variable name="altova:table">
																		<table class="table">
																			<xsl:variable name="altova:CurrContextGrid_3" select="."/>
																			<xsl:variable name="altova:ColumnData"/>
																			<thead>
																				<tr>
																					<th class="td_h_h w_3">
																						<span>
																							<xsl:text>Begin Value</xsl:text>
																						</span>
																					</th>
																					<th class="td_h_h w_3">
																						<span>
																							<xsl:text>End Value</xsl:text>
																						</span>
																					</th>
																					<th class="td_h_h w_18p8">
																						<span>
																							<xsl:text>Description</xsl:text>
																						</span>
																					</th>
																				</tr>
																			</thead>
																			<tbody>
																				<xsl:for-each select="n1:RangesCollection">
																					<xsl:for-each select="n1:RangeDetails">
																						<tr>
																							<td class="td">
																								<xsl:for-each select="n1:RangeBeginValue">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																							<td class="td">
																								<xsl:for-each select="n1:RangeEndValue">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																							<td class="td">
																								<xsl:for-each select="n1:RangeShortDescription">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																						</tr>
																					</xsl:for-each>
																				</xsl:for-each>
																			</tbody>
																		</table>
																	</xsl:variable>
																	<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
																	<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
																	<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
																		<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
																	</xsl:apply-templates>
																</xsl:if>
																<xsl:if test="count( n1:ValueListsCollection ) != 0">
																	<br/>
																	<span class="t_cap">
																		<xsl:text>Values List</xsl:text>
																	</span>
																	<br/>
																	<xsl:variable name="altova:table">
																		<table class="table">
																			<xsl:variable name="altova:CurrContextGrid_4" select="."/>
																			<xsl:variable name="altova:ColumnData"/>
																			<thead>
																				<tr>
																					<th class="td_h_h w_3">
																						<span>
																							<xsl:text>Value</xsl:text>
																						</span>
																					</th>
																					<th class="td_h_h w_21p8">
																						<span>
																							<xsl:text>Description</xsl:text>
																						</span>
																					</th>
																				</tr>
																			</thead>
																			<tbody>
																				<xsl:for-each select="n1:ValueListsCollection">
																					<xsl:for-each select="n1:ValueListDetails">
																						<tr>
																							<td class="td">
																								<xsl:for-each select="n1:VLValue">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																							<td class="td">
																								<xsl:for-each select="n1:VLShortDescription">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																						</tr>
																					</xsl:for-each>
																				</xsl:for-each>
																			</tbody>
																		</table>
																	</xsl:variable>
																	<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
																	<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
																	<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
																		<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
																	</xsl:apply-templates>
																</xsl:if>
																<xsl:if test="count( n1:CheckConstraintsCollection ) != 0">
																	<br/>
																	<span class="t_cap">
																		<xsl:text>Check Constraints</xsl:text>
																	</span>
																	<xsl:variable name="altova:table">
																		<table class="table">
																			<xsl:variable name="altova:CurrContextGrid_5" select="."/>
																			<xsl:variable name="altova:ColumnData"/>
																			<thead>
																				<tr>
																					<th class="td_h_h w_21p8">
																						<span>
																							<xsl:text>Text</xsl:text>
																						</span>
																					</th>
																					<th class="td_h_h w_3">
																						<span>
																							<xsl:text>DB Type</xsl:text>
																						</span>
																					</th>
																				</tr>
																			</thead>
																			<tbody>
																				<xsl:for-each select="n1:CheckConstraintsCollection">
																					<xsl:for-each select="n1:CheckConstraintDetails">
																						<tr>
																							<td class="td">
																								<xsl:for-each select="n1:CheckConstraintText">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																							<td class="td">
																								<xsl:for-each select="n1:DatabaseType">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																						</tr>
																					</xsl:for-each>
																				</xsl:for-each>
																			</tbody>
																		</table>
																	</xsl:variable>
																	<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
																	<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
																	<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
																		<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
																	</xsl:apply-templates>
																</xsl:if>
															</td>
														</tr>
													</xsl:for-each>
												</xsl:for-each>
											</tbody>
										</table>
									</xsl:variable>
									<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
									<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
									<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
										<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
									</xsl:apply-templates>
								</xsl:if>
								<xsl:if test="count( n1:TablesCollection )">
									<p/>
									<span class="t_cap">
										<xsl:text>Used In Tables</xsl:text>
									</span>
									<br/>
									<xsl:variable name="altova:table">
										<table class="w_25">
											<xsl:variable name="altova:CurrContextGrid_6" select="."/>
											<xsl:variable name="altova:ColumnData"/>
											<thead>
												<tr>
													<th class="td_h_h w_8">
														<span>
															<xsl:text>Model Name</xsl:text>
														</span>
													</th>
													<th class="td_h_h w_8p5">
														<span>
															<xsl:text>Table Name</xsl:text>
														</span>
													</th>
													<th class="td_h_h w_8p5">
														<span>
															<xsl:text>Column Name</xsl:text>
														</span>
													</th>
												</tr>
											</thead>
											<tbody>
												<xsl:for-each select="n1:TablesCollection">
													<xsl:for-each select="n1:TableDetails">
														<tr>
															<td class="td">
																<xsl:for-each select="n1:ModelName">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</td>
															<td class="td">
																<xsl:for-each select="n1:TableName">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</td>
															<td class="td">
																<xsl:for-each select="n1:ColumnName">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</td>
														</tr>
													</xsl:for-each>
												</xsl:for-each>
											</tbody>
										</table>
									</xsl:variable>
									<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
									<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
									<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
										<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
									</xsl:apply-templates>
								</xsl:if>
								<xsl:if test="count( n1:EntitiesCollection )">
									<p/>
									<span class="t_cap">
										<xsl:text>Used In Entities</xsl:text>
									</span>
									<xsl:variable name="altova:table">
										<table class="w_25">
											<xsl:variable name="altova:CurrContextGrid_7" select="."/>
											<xsl:variable name="altova:ColumnData"/>
											<thead>
												<tr>
													<th class="td_h_h w_12p5">
														<span>
															<xsl:text>Entity Name</xsl:text>
														</span>
													</th>
													<th class="td_h_h w_12p5">
														<span>
															<xsl:text>Attribute Name</xsl:text>
														</span>
													</th>
												</tr>
											</thead>
											<tbody>
												<xsl:for-each select="n1:EntitiesCollection">
													<xsl:for-each select="n1:EntityDetails">
														<tr>
															<td class="td">
																<xsl:for-each select="n1:EntityName">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</td>
															<td class="td">
																<xsl:for-each select="n1:AttributeName">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</td>
														</tr>
													</xsl:for-each>
												</xsl:for-each>
											</tbody>
										</table>
									</xsl:variable>
									<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
									<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
									<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
										<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
									</xsl:apply-templates>
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
	<xsl:function name="altova:is-cell-empty" as="xs:boolean">
		<xsl:param name="altova:cell" as="element()"/>
		<xsl:sequence select="altova:is-node-empty( $altova:cell )"/>
	</xsl:function>
	<xsl:function name="altova:is-node-empty" as="xs:boolean">
		<xsl:param name="altova:node" as="element()"/>
		<xsl:sequence select="every $altova:child in $altova:node/child::node() satisfies ( ( boolean( $altova:child/self::text() ) and string-length( $altova:child ) = 0 ) or ( ( boolean( $altova:child/self::div ) or boolean( $altova:child/self::span ) or boolean( $altova:child/self::a ) ) and altova:is-node-empty( $altova:child ) ) )"/>
	</xsl:function>
	<xsl:function name="altova:col-span" as="xs:integer">
		<xsl:param name="altova:cell" as="element()"/>
		<xsl:sequence select="if ( exists( $altova:cell/@colspan ) ) then xs:integer( $altova:cell/@colspan ) else 1"/>
	</xsl:function>
	<xsl:template match="@* | node()" mode="altova:generate-table">
		<xsl:param name="altova:generate-cols"/>
		<xsl:copy>
			<xsl:apply-templates select="@* | node()" mode="#current">
				<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="tbody" mode="altova:generate-table">
		<xsl:param name="altova:generate-cols"/>
		<xsl:choose>
			<xsl:when test="empty(tr)">
				<xsl:copy>
					<tr>
						<td/>
					</tr>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@* | node()" mode="#current">
						<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="th | td" mode="altova:generate-table">
		<xsl:choose>
			<xsl:when test="altova:is-cell-empty( . )">
				<xsl:copy>
					<xsl:apply-templates select="@*" mode="#current"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@* | node()" mode="#current"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:function name="altova:GetChartYValuesForSingleSeries">
		<xsl:param name="seqCategoryLeafPos" as="node()*"/>
		<xsl:param name="nodeSeriesLeafPos" as="node()"/>
		<xsl:param name="bValuesInCategory" as="xs:boolean"/>
		<xsl:for-each select="$seqCategoryLeafPos">
			<xsl:element name="altova:Value">
				<xsl:value-of select="altova:GetChartYValueForSingleSeriesPos($nodeSeriesLeafPos, ., $bValuesInCategory)"/>
			</xsl:element>
		</xsl:for-each>
	</xsl:function>
	<xsl:function name="altova:GetChartYValueForSingleSeriesPos">
		<xsl:param name="nodeSeriesLeafPos" as="node()"/>
		<xsl:param name="nodeCategoryLeafPos" as="node()"/>
		<xsl:param name="bValuesInCategory" as="xs:boolean"/>
		<xsl:variable name="altova:seqCategoryContextIds" select="$nodeCategoryLeafPos/altova:Context/@altova:ContextId" as="xs:string*"/>
		<xsl:variable name="altova:seqSeriesContextIds" select="$nodeSeriesLeafPos/altova:Context/@altova:ContextId" as="xs:string*"/>
		<xsl:variable name="altova:sCommonContextId" select="for $i in $altova:seqCategoryContextIds return if (some $j in $altova:seqSeriesContextIds satisfies $i eq $j) then $i else ()" as="xs:string*"/>
		<xsl:choose>
			<xsl:when test="count($altova:sCommonContextId) gt 1">
				<xsl:message select="concat('Found several values instead of a single one (contexts: ', string-join($altova:sCommonContextId, ', '), ').')" terminate="yes"/>
			</xsl:when>
			<xsl:when test="count($altova:sCommonContextId) lt 1">
				<xsl:message select="concat('XBRL Chart: Info: No value found for position labeled &quot;', $nodeCategoryLeafPos/@altova:sLabel, '&quot;')" terminate="no"/>
				<xsl:sequence select="'altova:no-value'"/>
			</xsl:when>
			<xsl:when test="$bValuesInCategory">
				<xsl:sequence select="xs:string($nodeCategoryLeafPos/altova:Context[@altova:ContextId eq $altova:sCommonContextId]/@altova:Value)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:sequence select="xs:string($nodeSeriesLeafPos/altova:Context[@altova:ContextId eq $altova:sCommonContextId]/@altova:Value)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:GetChartLabelForPos" as="xs:string">
		<xsl:param name="nodeParam" as="node()"/>
		<xsl:value-of select="string-join($nodeParam/ancestor-or-self::altova:Pos/@altova:sLabel, ' ')"/>
	</xsl:function>
	<xsl:function name="altova:convert-length-to-pixel" as="xs:decimal">
		<xsl:param name="altova:length"/>
		<xsl:variable name="normLength" select="normalize-space($altova:length)"/>
		<xsl:choose>
			<xsl:when test="ends-with($normLength, 'px')">
				<xsl:value-of select="substring-before($normLength, 'px')"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'in')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'in')) * $altova:nPxPerIn"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'cm')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'cm')) * $altova:nPxPerIn div 2.54"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'mm')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'mm')) * $altova:nPxPerIn div 25.4"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pt')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pt')) * $altova:nPxPerIn div 72.0"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pc')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pc')) * $altova:nPxPerIn div 6.0"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$normLength"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:convert-length-to-mm" as="xs:decimal">
		<xsl:param name="altova:length"/>
		<xsl:variable name="normLength" select="normalize-space($altova:length)"/>
		<xsl:choose>
			<xsl:when test="ends-with($normLength, 'px')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'px')) div $altova:nPxPerIn * 25.4"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'in')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'in')) * 25.4"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'cm')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'cm')) * 10"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'mm')">
				<xsl:value-of select="substring-before($normLength, 'mm') "/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pt')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pt')) * 25.4 div 72.0"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pc')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pc')) * 25.4 div 6.0"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number($normLength) div $altova:nPxPerIn * 25.4"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
</xsl:stylesheet>
