package javax.ide.wizard.spi;

/**
 * The category of a wizard.
 */
public final class WizardCategory
{
  /**
   * Category indicating the root, or no category.
   */
  public static final WizardCategory NONE = 
    new WizardCategory( null, "__root__" );
  
  private final WizardCategory _parent;
  private String _id;
  private String _label;
  
  WizardCategory( WizardCategory parent, String id )
  {
    _id = id;
    _parent = parent == null ? NONE : parent;
  }
  
  /**
   * Get the id of this category.
   * 
   * @return the id of this category.
   */
  public String getId()
  {
    return _id;
  }

  /**
   * Get the label of this category.
   * 
   * @return the label of this category.
   */
  public String getLabel()
  {
    return _label;
  }
  
  /**
   * Get the parent category of this category.
   * 
   * @return the parent category of this category, or {@link #NONE} if there
   *    is no parent.
   */
  public WizardCategory getParent()
  {
    return _parent;
  }

  void setLabel( String label )
  {
    _label = label;
  }
  
  public String toString()
  {
    return "WizardCategory"+
      "[id="+String.valueOf( _id )+
      ",label="+String.valueOf(_label)+
      ",parent="+String.valueOf(_parent)+
      "]";
  }
  
  public boolean equals( Object o )
  {
    if ( o == this )
    {
      return true;
    }
    if ( !(o instanceof WizardCategory) )
    {
      return false;
    }
    WizardCategory other = (WizardCategory)o;

    return other._id.equals( _id ); 
  }
  
  public int hashCode()
  {
    return 37 * _id.hashCode();
  }
}
