/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.view;

import javax.ide.Identifiable;
import javax.ide.command.Context;
import javax.ide.command.Controller;

/**
 * <code>View</code> components display information to the user. A view
 * obtains the data from the model. There can be multiple views of the model.
 *
 * Each <code>View</code> has an associated {@link Controller}.
 * Controllers receive requests to handle the commands associated with user
 * interaction with the view.
 */
public abstract class View extends DefaultViewable implements Identifiable
{
  /**
   * Get the root graphical user interface component.
   */
  public abstract GUIPanel  getGUI();

  /**
   * Show/hide view.
   * @param visible The visible state of the view.
   */
  public abstract void setVisible( boolean visible );

  /**
   * Determine whether the View is visible.
   * @return The visible state of the view.
   */
  public abstract boolean isVisible();

  /**
   * Gets the current view context.
   * @return The current view {@link Context}.
   */
  public abstract Context getContext();

  /**
   * Called when the View gains the input focus. View implementations 
   * generally respond to the fact that this View is now the active view by 
   * updating the view display, for example.
   */
  public abstract void activate();

  /**
   * Called when the View looses the input focus. View implementations
   * generally, respond to the fact that this View is no longer the active 
   * view by reversing actions taken during view activation.
   */
  public abstract void deactivate();

  /**
   * Get the <code>Controller</code> associated with this view.
   * @return The {@link Controller} responsible for handling the actions that
   * can be executed from this view.
   */
  public abstract Controller getController();

  /**
   * Get the parent view. 
   * @return The parent view hosting this view.
   */
  public abstract View parent();
  
}
