package javax.ide.progress;

/**
 * <code>IProgressListener</code> is used by ProgressManager for generic progress reporting.
 *
 * @author <a href="mailto:chris.bensen@oracle.com">Chris Bensen</a>
 */

public interface IProgressListener
{
  /**
   * updateProgressTitle updates the progres title.
   * @param title
   */
  public void updateProgressTitle(String title);

  /**
   * updateProgressDescription updates the description and the ticks at the same time.
   * @param description
   * @param count
   */
  public void updateProgressDescription(String description, int count);

  /**
   * updateProgress updates the progress chunk by count ticks.
   * @param count
   */
  public void updateProgress(int count);

  /**
   * finalizeProgress is called to provide the number of ticks for this chunk of progress.
   * @param count
   */
  public void finalizeProgress(int count);

  /**
   * completeProgress is called when the progres is completed.
   */
  public void completeProgress();
}