/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.ide.util.MetaClass;

/**
 * Information about how to recognize an XML document by its root element.
 */
public final class XMLDocTypeRecognizer extends SuffixRecognizer
{
  private Collection _docTypes = new HashSet();
  
  public XMLDocTypeRecognizer( MetaClass documentClass )
  {
    super( documentClass );    
  }
  
  public void addDocType( XMLDocType docType )
  {
    _docTypes.add( docType );
  }
  
  public Collection getSuffixes()
  {
    Collection suffixes = super.getSuffixes();
    if ( suffixes.isEmpty() )
    {
      return Collections.singleton( ".xml" );
    }
    return suffixes;
  }
  
  public Collection getDocTypes()
  {
    return Collections.unmodifiableCollection( _docTypes );
  }
}
