/*
 * @(#)VariableDeclT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * Common supertype for field declarations and local variable
 * declarations.
 *
 * @author Andy Yu
 * */
public interface VariableDeclT
  extends Tree, HasModifiersT
{
  // ----------------------------------------------------------------------

  /**
   * Gets the list of declared variables. If this is an enum constant,
   * there can never be more than one variable.
   *
   * @return Array of variables declared in this field.  <p/>
   *
   * List of VariableTs.
   */
  public List getVariables();


  // ----------------------------------------------------------------------

  /**
   * Gets the type reference for this element.
   *
   * @return This element's type reference.
   */
  public TypeReferenceT getType();

  /**
   * Unlinks the current source type and links the input element.
   * 
   * @param type The new type reference.
   *
   * @throws IllegalStateException if the input type is already linked.
   */
  public void setType( TypeReferenceT type );
}
