/*
 * @(#)TypeParameterT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * A type parameter declaration.
 *
 * @author Andy Yu
 * */
public interface TypeParameterT
  extends Tree, HasNameT
{
  // ----------------------------------------------------------------------

  public static final TypeParameterT[] EMPTY_ARRAY =
    new TypeParameterT[ 0 ];

  // ----------------------------------------------------------------------

  /**
   * A type bound on a type parameter has the following form
   * "<base_ty extends ty_bound & ty_bound & ty_bound>".
   *
   * @return The array of type bounds. Always non-null, may be
   * zero-length. <p/>
   *
   * List of TypeReferenceTs.
   */
  public List getBounds();


  // ----------------------------------------------------------------------
}
