/*
 * @(#)StatementT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * Common supertype of all statements. All statements can be
 * classified as: simple, block, compound. Block statements are
 * statements that are blocks. Simple statements have no child
 * statements and optionally have expressions. Compound statements
 * have child statements and optionally have expressions. <p/>
 *
 * @author Andy Yu
 * */
public interface StatementT
  extends Tree, BlockElementT
{
  // ----------------------------------------------------------------------

  public final static StatementT[] EMPTY_ARRAY = new StatementT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * @return The StatementLabelT array corresponding to this statement's
   * label. Unlike all the other parse tree API array calls, this
   * returns null if there are no labels. This is because labels
   * rarely occur and there's no point creating a zero-length array
   * for each statement. <p/>
   *
   * List of StatementLabelTs.
   */
  public List getStatementLabels();


  // ----------------------------------------------------------------------
}
