/*
 * @(#)SimpleStatementT.java
 */

package javax.ide.model.java.source.tree;

/**
 * Common supertype for statements that have no child statement but
 * may optionally have expressions. This includes the following types
 * of statements: empty, expression, break, continue, return, throw,
 * assert. <p/>
 *
 * @author Andy Yu
 * */
public interface SimpleStatementT
  extends StatementT
{
  // ----------------------------------------------------------------------

  /**
   * Valid for "break" and "continue" statements.
   * @return The name of the target label. Null if none.
   */
  public NameT getExpressionName();

  /**
   * Valid for "return", "throw", and "assert" statements and for
   * "case" labels.
   *
   * @return the ExpressionT for this expression symbol. Null if this
   * is an empty expression statement.
   */
  public ExpressionT getExpression();


  // ----------------------------------------------------------------------
}
