/*
 * @(#)NewArrayExpressionT.java
 */

package javax.ide.model.java.source.tree;

/**
 * An expression creating a new array. Array creators come in
 * two flavors: normal and (explicitly) initialized. <p/>
 *
 * @author Andy Yu
 * */
public interface NewArrayExpressionT
  extends ExpressionT
{
  /**
   * Gets the type reference for this element.
   *
   * @return This element's type reference.
   */
  public TypeReferenceT getType();

  /**
   * Unlinks the current source type and links the input element.
   * 
   * @param type The new type reference.
   *
   * @throws IllegalStateException if the input type is already linked.
   */
  public void setType( TypeReferenceT type );

}
