/*
 * @(#)InvokeExpressionT.java
 */

package javax.ide.model.java.source.tree;

/**
 * Common supertype for an expression that invokes a method. <p/>
 *
 * @author Andy Yu
 * */
public interface InvokeExpressionT
  extends DereferenceExpressionT
{
  // ----------------------------------------------------------------------

  /**
   * @return The argument list expression, i.e. the expression
   * representing the argument list.
   */
  public ListExpressionT getArgumentList();

  /**
   * Equivalent to calling getArgumentList().getOperandCount().
   *
   * @return The size of the argument list expression.
   */
  public int getArgumentCount();

  /**
   * Equivalent to calling getArgumentList().getOperandAt( i ).
   *
   * @param i 0-based.
   */
  public ExpressionT getArgumentAt( int i );
}
