/*
 * @(#)InterfacesT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * An interfaces clause of a type declaration. On a "class" or "enum"
 * type, this is the "extends" clause. On an "interface" type, this is
 * the "implements" clause. <p/>
 * 
 * @author Andy Yu
 * */
public interface InterfacesT
  extends Tree
{
  // ----------------------------------------------------------------------

  /**
   * Gets the superinterface types. Not to be confused with inner
   * classes that are interface types. The name was chosen to be
   * consistent with JavaType and java/lang/Class.
   *
   * @return The source-model declared base interfaces. May be
   * zero-length. Will have an element for each super interface that
   * is declared, even if the super interface cannot be found. <p/>
   *
   * List of TypeReferenceTs.
   */
  public List getInterfaces();


  // ----------------------------------------------------------------------
}
