/*
 * @(#)HasModifiersT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * Common supertype for elements that may have modifiers. Note that an
 * annotation is considered a modifier. <p/>
 *
 * @author Andy Yu
 */
public interface HasModifiersT
  extends Tree
{
  // ----------------------------------------------------------------------

  /**
   * Gets the modifiers. Right now, this returns the effective
   * modifiers rather than the raw modifiers.
   *
   * @return The modifiers associated with this object.
   */
  public int getModifiers();

  /**
   * Adds the modifiers except for INTERFACE, ENUM, and ANNOTATION.
   *
   * @param modifiers Valid values come from JavaConstants.ACC_* and are
   *                  determined on a per-node basis. <p/>
   *
   *                  The following modifiers are always ignored:
   *                  ACC_INTERFACE, ACC_ENUM, ACC_ANNOTATION. In order
   *                  to set them, you must use the special setter
   *                  ClassT.setTypeKind(I).
   *
   * @throws UnsupportedOperationException if this operation is illegal.
   */
  public void addModifiers( int modifiers );

  /**
   * Sets the modifiers except for INTERFACE, ENUM, and ANNOTATION.
   *
   * @param modifiers Valid values come from JavaConstants.ACC_* and are
   *                  determined on a per-node basis. <p/>
   *
   *                  The following modifiers are always ignored:
   *                  ACC_INTERFACE, ACC_ENUM, ACC_ANNOTATION. In order
   *                  to set them, you must use the special setter
   *                  ClassT.setTypeKind(I).
   *
   * @throws UnsupportedOperationException if this operation is illegal.
   */
  public void setModifiers( int modifiers );

  /**
   * Removes the modifiers.
   *
   * @param modifiers Valid values come from JavaConstants.ACC_* and are
   *                  determined on a per-node basis.
   *
   * @throws UnsupportedOperationException if this operation is illegal.
   */
  public void removeModifiers( int modifiers );

  /**
   * Gets the list of annotations.
   *
   * @return The array of annotations on this object. <p/>
   *
   * List of AnnotationTs.
   */
  public List getAnnotations();


  // ----------------------------------------------------------------------

  /**
   * True if this is public.
   *
   * @return True if this is public.
   */
  public boolean isPublic();

  /**
   * True if this is private.
   *
   * @return True if this is private.
   */
  public boolean isPrivate();

  /**
   * True if this is protected.
   *
   * @return True if this is protected.
   */
  public boolean isProtected();

  /**
   * True if this is static.
   *
   * @return True if this is static.
   */
  public boolean isStatic();

  /**
   * True if this is final.
   *
   * @return True if this is final.
   */
  public boolean isFinal();

  /**
   * True if this is abstract.
   *
   * @return True if this is abstract.
   */
  public boolean isAbstract();

  /**
   * True if this is strictfp.
   *
   * @return True if this is strictfp.
   */
  public boolean isStrictfp();


  // ----------------------------------------------------------------------
}

