/*
 * @(#)AnnotationT.java
 */

package javax.ide.model.java.source.tree;

/**
 * An annotation (not to be confused with annotation type).  Any
 * declaration may be annotated, in particular, that means any T that
 * extends HasModifiersT. <p/>
 * 
 * For more information, please refer to the JLS 3rd ed, section
 * 9.7. <p/>
 * 
 * The first annotation variant is called a "normal" annotation.
 * Consider: <p/>
 *
 * <pre>
 *   // Normal annotation
 *   {@literal @}RequestForEnhancement(
 *     id = 2868724,
 *     synopsis = "Provide time-travel functionality",
 *     engineer = "Mr. Peabody",
 *     date = "4/1/2004"
 *   )
 *   public static void travelThroughTime(Date destination) { ... }
 * </pre>
 *
 * getArguments() will return a list of four elements, each one will be
 * an AssignmentExpressionT. The first argument will have a lhs for
 * "id" and a rhs for "2868724". <p/>
 * 
 * The second annotation variant is called a "marker"
 * annotation. Consider: <p/>
 *
 * <pre>
 *   {@literal @}Deprecated
 *   class MyClass { }
 * </pre>
 *
 * getArguments() will return an empty list. In particular,
 * getArgumentList() will return a synthetic ListExpressionT. <p/>
 * 
 * The third annotation variant is called a "single-element"
 * annotation.  Consider: <p/>
 *
 * <pre>
 *   // Single-element annotation
 *   {@literal @}Copyright("2002 Yoyodyne Propulsion Systems, Inc., ...")
 *   public class OscillationOverthruster { ... } * </pre>
 * </pre>
 *
 * getArguments() will return a list of one element. The single argument
 * will be an expression for "2002 Yoydyne..." etc. Note: This single
 * argument will NOT be an AssignmentExpressionT. <p/>
 * 
 * @see HasModifiersT
 *
 * @author Andy Yu
 */
public interface AnnotationT
  extends Tree, HasNameT
{
  // ----------------------------------------------------------------------

  public static final AnnotationT[] EMPTY_ARRAY = new AnnotationT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * Gets the argument list as a tree.
   *
   * @return The argument list expression used to construct this annotation.
   * Always non-null. If this is a marker annotation, then the returned
   * ListExpressionT will be marked synthetic. Adding a child to said
   * argument list will automatically remove the synthetic modifier.
   */
  public ListExpressionT getArgumentList();
  
  /**
   * Gets the number of arguments.  Equivalent to calling
   * <code>getArgumentList().getOperandCount()</code> or
   * <code>getArguments().size()</code>.
   *
   * @return The size of the argument list expression.
   */
  public int getArgumentCount();

  /**
   * Gets the indicated argument.  Equivalent to calling
   * <code>getArgumentList().getOperandAt(i)</code> or
   * <code>getArguments().get(i)</code>.
   *
   * @param i 0-based.
   * 
   * @return The argument at the given index.
   */
  public ExpressionT getArgumentAt( int i );
}
