/*
 * @(#)TreeVisitor.java
 */

package javax.ide.model.java.source;

import javax.ide.model.java.source.tree.AnnotationExpressionT;
import javax.ide.model.java.source.tree.AnnotationT;
import javax.ide.model.java.source.tree.ArrayAccessExpressionT;
import javax.ide.model.java.source.tree.AssertStatementT;
import javax.ide.model.java.source.tree.AssignmentExpressionT;
import javax.ide.model.java.source.tree.BlockStatementT;
import javax.ide.model.java.source.tree.BlockT;
import javax.ide.model.java.source.tree.BreakStatementT;
import javax.ide.model.java.source.tree.CatchClauseT;
import javax.ide.model.java.source.tree.ClassBodyT;
import javax.ide.model.java.source.tree.ClassInitializerT;
import javax.ide.model.java.source.tree.ClassT;
import javax.ide.model.java.source.tree.ContinueStatementT;
import javax.ide.model.java.source.tree.DoStatementT;
import javax.ide.model.java.source.tree.DocCommentT;
import javax.ide.model.java.source.tree.DotExpressionT;
import javax.ide.model.java.source.tree.ElseClauseT;
import javax.ide.model.java.source.tree.EmptyStatementT;
import javax.ide.model.java.source.tree.EnumConstantT;
import javax.ide.model.java.source.tree.ExpressionStatementT;
import javax.ide.model.java.source.tree.FieldDeclT;
import javax.ide.model.java.source.tree.FieldVariableT;
import javax.ide.model.java.source.tree.FileT;
import javax.ide.model.java.source.tree.FinallyClauseT;
import javax.ide.model.java.source.tree.ForStatementT;
import javax.ide.model.java.source.tree.FormalParameterListT;
import javax.ide.model.java.source.tree.FormalParameterT;
import javax.ide.model.java.source.tree.IdentifierExpressionT;
import javax.ide.model.java.source.tree.IfStatementT;
import javax.ide.model.java.source.tree.ImportT;
import javax.ide.model.java.source.tree.InfixExpressionT;
import javax.ide.model.java.source.tree.InterfacesT;
import javax.ide.model.java.source.tree.ListExpressionT;
import javax.ide.model.java.source.tree.LiteralExpressionT;
import javax.ide.model.java.source.tree.LocalVariableDeclT;
import javax.ide.model.java.source.tree.LocalVariableT;
import javax.ide.model.java.source.tree.MethodCallExpressionT;
import javax.ide.model.java.source.tree.MethodT;
import javax.ide.model.java.source.tree.NameT;
import javax.ide.model.java.source.tree.NewArrayExpressionT;
import javax.ide.model.java.source.tree.NewClassExpressionT;
import javax.ide.model.java.source.tree.PackageT;
import javax.ide.model.java.source.tree.QuestionExpressionT;
import javax.ide.model.java.source.tree.ReturnStatementT;
import javax.ide.model.java.source.tree.StatementLabelT;
import javax.ide.model.java.source.tree.SuperclassT;
import javax.ide.model.java.source.tree.SwitchLabelT;
import javax.ide.model.java.source.tree.SwitchStatementT;
import javax.ide.model.java.source.tree.SynchStatementT;
import javax.ide.model.java.source.tree.ThrowStatementT;
import javax.ide.model.java.source.tree.ThrowsT;
import javax.ide.model.java.source.tree.TryStatementT;
import javax.ide.model.java.source.tree.TypeArgumentT;
import javax.ide.model.java.source.tree.TypeExpressionT;
import javax.ide.model.java.source.tree.TypeParameterT;
import javax.ide.model.java.source.tree.TypeReferenceT;
import javax.ide.model.java.source.tree.TypecastExpressionT;
import javax.ide.model.java.source.tree.UnaryExpressionT;
import javax.ide.model.java.source.tree.WhileStatementT;
import javax.ide.model.java.source.tree.WrapperExpressionT;

/**
 * A Visitor pattern for Trees.
 *
 * @author Andy Yu
 */
public abstract class TreeVisitor
{
  // ----------------------------------------------------------------------

  /**
   * Visits a AnnotationT.
   */
  public void visitAnnotation(AnnotationT tree) { }

  /**
   * Visits a AnnotationExpressionT.
   */
  public void visitAnnotationExpression(AnnotationExpressionT tree) { }

  /**
   * Visits a ArrayAccessExpressionT.
   */
  public void visitArrayAccessExpression(ArrayAccessExpressionT tree) { }

  /**
   * Visits a NewArrayExpressionT.
   */
  public void visitNewArrayExpression(NewArrayExpressionT tree) { }

  /**
   * Visits a AssertStatementT.
   */
  public void visitAssertStatement(AssertStatementT tree) { }

  /**
   * Visits a AssignmentExpressionT.
   */
  public void visitAssignmentExpression(AssignmentExpressionT tree) { }

  /**
   * Visits a BlockT.
   */
  public void visitBlock(BlockT tree) { }

  /**
   * Visits a BlockStatementT.
   */
  public void visitBlockStatement(BlockStatementT tree) { }

  /**
   * Visits a BreakStatementT.
   */
  public void visitBreakStatement(BreakStatementT tree) { }

  /**
   * Visits a CatchClauseT.
   */
  public void visitCatchClause(CatchClauseT tree) { }

  /**
   * Visits a ClassBodyT.
   */
  public void visitClassBody(ClassBodyT tree) { }

  /**
   * Visits a ClassT.
   */
  public void visitClassDeclaration(ClassT tree) { }

  /**
   * Visits a ClassInitializerT.
   */
  public void visitClassInitializer(ClassInitializerT tree) { }

  /**
   * Visits a MethodT for a constructor declaration.
   */
  public void visitConstructorDeclaration(MethodT tree) { }

  /**
   * Visits a ContinueStatementT.
   */
  public void visitContinueStatement(ContinueStatementT tree) { }

  /**
   * Visits a DoStatementT.
   */
  public void visitDoStatement(DoStatementT tree) { }

  /**
   * Visits a DocCommentT.
   */
  public void visitDocComment(DocCommentT tree) { }

  /**
   * Visits a DotExpressionT.
   */
  public void visitDotExpression(DotExpressionT tree) { }

  /**
   * Visits a ElseClauseT.
   */
  public void visitElseClause(ElseClauseT tree) { }

  /**
   * Visits a EmptyStatementT.
   */
  public void visitEmptyStatement(EmptyStatementT tree) { }

  /**
   * Visits an EnumConstantT.
   */
  public void visitEnumConstantDeclaration(EnumConstantT tree) { }

  /**
   * Visits a ExpressionStatementT.
   */
  public void visitExpressionStatement(ExpressionStatementT tree) { }

  /**
   * Visits a FieldDeclT that is not an enum constant.
   */
  public void visitFieldDeclaration(FieldDeclT tree) { }

  /**
   * Visits a FieldVariableT.
   */
  public void visitFieldVariable(FieldVariableT tree) { }

  /**
   * Visits a FileT.
   */
  public void visitFile(FileT tree) { }

  /**
   * Visits a FinallyClauseT.
   */
  public void visitFinallyClause(FinallyClauseT tree) { }

  /**
   * Visits a ForStatementT.
   */
  public void visitForStatement(ForStatementT tree) { }

  /**
   * Visits a FormalParameterT.
   */
  public void visitFormalParameter(FormalParameterT tree) { }

  /**
   * Visits a FormalParameterListT.
   */
  public void visitFormalParameterList(FormalParameterListT tree) { }

  /**
   * Visits a IdentifierExpressionT.
   */
  public void visitIdentifierExpression(IdentifierExpressionT tree) { }

  /**
   * Visits a IfStatementT.
   */
  public void visitIfStatement(IfStatementT tree) { }

  /**
   * Visits a ImportT.
   */
  public void visitImportDeclaration(ImportT tree) { }

  /**
   * Visits a InfixExpressionT.
   */
  public void visitInfixExpression(InfixExpressionT tree) { }

  /**
   * Visits a InterfacesT.
   */
  public void visitInterfacesClause(InterfacesT tree) { }

  /**
   * Visits a ListExpressionT.
   */
  public void visitListExpression(ListExpressionT tree) { }

  /**
   * Visits a LiteralExpressionT.
   */
  public void visitLiteralExpression(LiteralExpressionT tree) { }

  /**
   * Visits a LocalVariableT.
   */
  public void visitLocalVariable(LocalVariableT tree) { }

  /**
   * Visits a LocalVariableDeclT.
   */
  public void visitLocalVariableDeclaration(LocalVariableDeclT tree) { }

  /**
   * Visits a MethodCallExpressionT.
   */
  public void visitMethodCallExpression(MethodCallExpressionT tree) { }

  /**
   * Visits a MethodT that is not a constructor.
   */
  public void visitMethodDeclaration(MethodT tree) { }

  /**
   * Visits a NameT.
   */
  public void visitName(NameT tree) { }

  /**
   * Visits a NewClassExpressionT.
   */
  public void visitNewClassExpression(NewClassExpressionT tree) { }

  /**
   * Visits a PackageT.
   */
  public void visitPackageDeclaration(PackageT tree) { }

  /**
   * Visits a QuestionExpressionT.
   */
  public void visitQuestionExpression(QuestionExpressionT tree) { }

  /**
   * Visits a ReturnStatementT.
   */
  public void visitReturnStatement(ReturnStatementT tree) { }

  /**
   * Visits a StatementLabelT.
   */
  public void visitStatementLabel(StatementLabelT tree) { }

  /**
   * Visits a SuperclassT.
   */
  public void visitSuperclassClause(SuperclassT tree) { }

  /**
   * Visits a SwitchLabelT.
   */
  public void visitSwitchLabel(SwitchLabelT tree) { }

  /**
   * Visits a SwitchStatementT.
   */
  public void visitSwitchStatement(SwitchStatementT tree) { }

  /**
   * Visits a SynchStatementT.
   */
  public void visitSynchStatement(SynchStatementT tree) { }

  /**
   * Visits a ThrowStatementT.
   */
  public void visitThrowStatement(ThrowStatementT tree) { }

  /**
   * Visits a ThrowsT.
   */
  public void visitThrowsClause(ThrowsT tree) { }

  /**
   * Visits a TryStatementT.
   */
  public void visitTryStatement(TryStatementT tree) { }

  /**
   * Visits a TypeArgumentT.
   */
  public void visitTypeArgument(TypeArgumentT tree) { }

  /**
   * Visits a TypeExpressionT.
   */
  public void visitTypeExpression(TypeExpressionT tree) { }

  /**
   * Visits a TypeParameterT.
   */
  public void visitTypeParameter(TypeParameterT tree) { }

  /**
   * Visits a TypeReferenceT.
   */
  public void visitTypeReference(TypeReferenceT tree) { }

  /**
   * Visits a TypecastExpressionT.
   */
  public void visitTypecastExpression(TypecastExpressionT tree) { }

  /**
   * Visits a UnaryExpressionT.
   */
  public void visitUnaryExpression(UnaryExpressionT tree) { }

  /**
   * Visits a WhileStatementT.
   */
  public void visitWhileStatement(WhileStatementT tree) { }

  /**
   * Visits a WrapperExpressionT.
   */
  public void visitWrapperExpression(WrapperExpressionT tree) { }


  // ----------------------------------------------------------------------
}
