/*
 * @(#)TreeResolver.java
 */

package javax.ide.model.java.source;

import javax.ide.model.java.declaration.Declaration;
import javax.ide.model.java.declaration.TypeD;
import javax.ide.model.java.source.tree.Tree;

/**
 * The TreeResolver provides a facility for resolving type and declaration
 * references on Trees. Methods are provided for resolving individual
 * Tree objects. Other methods are provided for resolving an entire FileT.
 * <p/>
 * 
 * The TreeResolver may need to acquire resource(s) as it performs
 * resolution. Callers should be warned that TreeResolver operations may
 * therefore block unless the underlying resource has already been acquired.
 * <p/>
 * 
 * <h3> Constructors </h3>
 * 
 * There is one special case where a Tree resolves to a valid type and a
 * valid declaration that "seem" to not match, namely NewClassExpressionT.
 * The NewClassExpressionT will be resolved to a type which is the type
 * of the class being created. However, the NewClassExpressionT will
 * also resolve to a constructor declaration which, as you may recall,
 * have no return type. <p/>
 *
 * @author Andy Yu
 */
public interface TreeResolver
{
  // ----------------------------------------------------------------------

  /**
   * Resolves this tree into a declaration reference.
   * 
   * @return The resolved declaration this tree refers to, null if
   *         unresolvable.
   * 
   * @throws UnsupportedOperationException if this tree does not resolve
   *                                       to a declaration. Example: assert.
   */
  public Declaration getResolvedDeclaration(Tree tree);

  /**
   * Resolves this tree into a type reference.
   * 
   * @return The resolved type this tree refers to, null if unresolvable.
   * 
   * @throws UnsupportedOperationException if this tree does not resolve
   *                                       to a type. Example: assert.
   */
  public TypeD getResolvedType(Tree tree);


  // ----------------------------------------------------------------------
}
