/*
 * @(#)ClassD.java
 */

package javax.ide.model.java.declaration;

/**
 * Represents a primitive, class, interface, enum, or annotation
 * type. <p/>
 *
 * @author Andy Yu
 */
public interface ClassD
  extends TypeD, MemberD, GenericD, HasNameD, HasAnnotationsD
{
  // ----------------------------------------------------------------------

  /**
   * Gets the owning package.
   *
   * @return The owning package declaration. Null if this is a primitive or
   * an array type.
   */
  public PackageD getPackage();

  /**
   * Gets the qualified name of the owning package. Provided for
   * convenience.
   *
   * @return The qualified name of the owning package. Empty if none.
   */
  public String getPackageName();

  /**
   * True if this is modified with "abstract".
   *
   * @return True if this is modified with "abstract".
   */
  public boolean isAbstract();


  // ----------------------------------------------------------------------

  /**
   * True if this is a member inner class.
   *
   * @return True if this is a member inner class.
   */
  public boolean isMemberClass();


  // ----------------------------------------------------------------------

  /**
   * Gets the hidden <code>clinit</code> method, null if none.
   *
   * @return The method declaration for the <code>clinit</code> method,
   * null if none.
   */
  public MethodD getClinitMethod();
}
