/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model;

import java.net.URI;

import javax.ide.util.MetaClass;

/**
 *  The {@link Recognizer} interface provides the API for recognizing
 *  data types from specific uris.<P>
 *
 *  Data model frameworks can register their own recognizer with the
 *  {@link DocumentFactory}.
 *
 *  @see DocumentFactory
 */
public abstract class Recognizer
{
  /**
   *  Gets the {@link Class} of the data item associated with the
   *  specified {@link URI}.  Implementations must return
   *  <CODE>null</CODE> if the {@link URI} is not recognized. The
   *  {@link Class} returned must be the data model class.
   *
   *  @param  uri  unique {@link URI} identifying the document.
   *  @return  the document {@link MetaClass}.
   */
  public abstract MetaClass recognize( URI uri );

}
