/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model;

import java.util.Collection;

/**
 *  The <CODE>Folder</CODE> interface extends {@link Element} by adding
 *  methods for managing child {@link Element}s contained by the
 *  <CODE>Folder</CODE>.
 */
public interface Folder // extends Element
{
  /**
   *  Other classes can call this method to determine whether the given
   *  {@link Element} can be added to the <CODE>Folder</CODE>.
   *
   *  @param  element  the {@link Element} that is about to be added
   *  to this <CODE>Folder</CODE>.
   *
   *  @return <CODE>true</CODE> if the specified {@link Element} can be
   *  added to this <CODE>Folder</CODE>; <CODE>false</CODE> if the
   *  {@link Element} cannot be added.
   */
  public boolean canAdd( Element element );

  /**
   *  Appends a child {@link Element} to the end of the
   *  <CODE>Folder</CODE>.
   */
  public boolean add( Element child );

  /**
   *  Appends children {@link Element} to the end of the
   *  <CODE>Folder</CODE>.
   */
  public boolean add( Collection children );

  /**
   *  Other classes can call this method to determine whether the
   *  specified {@link Element} can be removed from this
   *  <CODE>Folder</CODE>.
   *
   *  @param  element  the {@link Element} that is about to be removed
   *  from this <CODE>Folder</CODE>.
   *
   *  @return <CODE>true</CODE> if the specified {@link Element} can be
   *  removed from this <CODE>Folder</CODE>; <CODE>false</CODE> if the
   *  {@link Element} cannot be removed.
   */
  public boolean canRemove( Element element );

  /**
   *  Removes the specified child {@link Element}.  If the child object
   *  appears more than once, only the first instance is removed.
   *
   *  @param  child  The child object to remove.
   */
  public boolean remove( Element child );

  /**
   *  Removes the specified children {@link Element}.  If any of the children
   *  appears more than once, only the first instance is removed.
   *
   *  @param  children  The children to remove.
   */
  public boolean remove( Collection children );

  /**
   *  Returns <CODE>true</CODE> if the folder contains the
   *  specified child {@link Element}; returns <CODE>false</CODE>
   *  otherwise.
   */
  public boolean containsChild( Element child );

  /**
   *  Returns the current number of children in the folder.
   */
  public int size();

  /**
   *  Removes all children from the folder.
   */
  public void removeAll();

}
