/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model;

import java.util.EventListener;

/**
 * The <code>DocumentListener</code> interface should be
 * implemented by clients that are interested in being notified about
 * operations on {@link javax.ide.model.Document}s.
 *
 * @see javax.ide.model.Document
 * @see DocumentEvent
 */
public interface DocumentListener extends EventListener
{
  /**
   * Notify listeners that the document has been opened.
   * @param event the {@link DocumentEvent}.
   */
  public void opened( DocumentEvent event );

  /**
   * Notify listeners that the document is about to be closed.
   * @param event the {@link DocumentEvent}.
   */
  public void willBeClosed( DocumentEvent event );

  /**
   * Notify listeners that the document has been closed. Clients should not
   * call {@link javax.ide.model.Document} methods that cause the document 
   * to be reopened.
   * @param event the {@link DocumentEvent}.
   */
  public void closed( DocumentEvent event );

  /**
   * Notify listeners that the document has been modified.
   * @param event the {@link DocumentEvent}.
   */
  public void modified( DocumentEvent event );

  /**
   * Notify listeners that the document is about to be saved.
   * @param event the {@link DocumentEvent}.
   */
  public void willBeSaved( DocumentEvent event );
  
  /**
   * Notify listeners that the document has been saved.
   * @param event the {@link DocumentEvent}.
   */
  public void saved( DocumentEvent event );
}
