/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model;

import java.util.EventObject;

/**
 * The DocumentEvent is used to indicate that state of a {@link Document}
 * has been modified.
 */
public final class DocumentEvent extends EventObject
{
  /**
   * Constructor.
   *
   * @param document the document whose state has been altered.
   */
  public DocumentEvent( Document document )
  {
    super(document);
  }

  /**
   * Get the {@link Document} whose state has changed.  
   * This is functionally equivalent to casting the result of getSource() to 
   * a <code>Document</code> object.
   *
   * @return the {@link Document} whose state has changed.
   */
  public Document getDocument() 
  {
    return (Document)getSource();
  }
}
