/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;

import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.OnDemandElementVisitor;

final class ToolbarsVisitor extends OnDemandElementVisitor
{
  private static final ElementName TOOLBAR = element( "toolbar" );

  private ToolbarVisitorListener _listener;

  private final static ElementName element( String name )
  {
    return new ElementName( ExtensionHook.MANIFEST_XMLNS, name );
  }

  private final ElementVisitor _toolbarHandler = new ToolbarHandler();

  @Override
  protected void startImpl( ElementStartContext context )
  {
    context.registerChildVisitor( TOOLBAR, _toolbarHandler );
  }

  public void addToolbarVistorListener( ToolbarVisitorListener listener )
  {
    super.addRegListener( listener );
    _listener = listener;
  }
  
  public void removeToolbarVistorListener( ToolbarVisitorListener listener )
  {
    super.removeRegListener( listener );
    _listener = null;
  }

  private class ToolbarHandler extends ElementVisitor
  {
    private final ElementVisitor _sectionHandler = new SectionVisitor();

    public void start( ElementStartContext context )
    {
      String id = context.getAttributeValue( "id" );
      if ( id == null || ( id = id.trim() ).length() == 0 )
      {
        log( context, Level.SEVERE, "Missing required attribute 'id'." );
        return;
      }

      // Notify the listener that new items are being added to
      // the toolbar identified by id
      if (_listener != null)
      {
        _listener.addedToToolbar( id );
      }

      MenuModel model = 
        ( MenuModel ) context.getScopeData().get( MenuHook.KEY_MENU_MODEL );

      Toolbar toolbar = model.findOrCreateToolbar( id );
      context.getScopeData().put( MenuHook.KEY_SECTION_CONTAINER, toolbar );
      context.registerChildVisitor( SectionVisitor.SECTION, _sectionHandler );
    }
  }

}
