package javax.ide.extension.spi;

import javax.xml.stream.Location;


final class LocationImpl
  implements Location
{
  private final String _publicId;
  private final String _systemId;
  private final int _column;
  private final int _line;
  private final int _offset;
  
  public LocationImpl(Location location) {
    _publicId = location.getPublicId();
    _systemId = location.getSystemId();
    _column = location.getColumnNumber();
    _line = location.getLineNumber();
    _offset = location.getCharacterOffset();
  }
  
  public LocationImpl(String publicId, String systemId, int column, int line, int offset )
  {
    _publicId = publicId;
    _systemId = systemId;
    _column = column;
    _line = line;
    _offset = offset;
  }

  public LocationImpl(String publicId, String systemId )
  {
    this( publicId, systemId, 0, 0, 0 );
  }

  public LocationImpl(String systemId )
  {
    this( systemId, systemId );
  }


  public int getColumnNumber()
  {
    return _column;
  }

  public int getLineNumber()
  {
    return _line;
  }

  public String getPublicId()
  {
    return _publicId;
  }

  public String getSystemId()
  {
    return _systemId;
  }

  @Override
  public int getCharacterOffset()
  {
    return _offset;
  }
}
