package javax.ide.extension.spi;

import javax.xml.stream.Location;

import org.xml.sax.Locator;


public class LocationAdapterImpl implements LocationAdapter
{
  private final Location m_streamLocation;
  private final Locator m_saxLocator;
  public LocationAdapterImpl(Location loc)
  {
    if (loc == null) throw new IllegalArgumentException("location passed in must not be null");
    m_streamLocation = loc;
    m_saxLocator = null;
  }
  
  public LocationAdapterImpl(Locator loc)
  {
    if (loc == null) throw new IllegalArgumentException("locator passed in must not be null");
    m_saxLocator = loc;
    m_streamLocation = null;
  }
  
  @Override
  public int getLineNumber()
  {
    return m_streamLocation != null ? m_streamLocation.getLineNumber() : m_saxLocator.getLineNumber();
  }

  @Override
  public int getColumnNumber()
  {
    return m_streamLocation != null ? m_streamLocation.getColumnNumber() : m_saxLocator.getColumnNumber();
  }

  @Override
  public int getCharacterOffset()
  {
    return m_streamLocation != null ? m_streamLocation.getCharacterOffset() : -1;
  }

  @Override
  public String getPublicId()
  {
    return m_streamLocation != null ? m_streamLocation.getPublicId() : m_saxLocator.getPublicId();
  }

  @Override
  public String getSystemId()
  {
    return m_streamLocation != null ? m_streamLocation.getSystemId() : m_saxLocator.getSystemId();
  }
  
  @Override
  public LocationAdapter copyMe() {
    if (m_streamLocation != null )
      return new LocationAdapterImpl( new LocationImpl(m_streamLocation) );
    else
      return new LocationAdapterImpl( new LocatorImpl(m_saxLocator) );
  }
}
