/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension.spi;

import java.util.Map;

import javax.ide.Service;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
/**
 * The feature registry provides access to information about extensions which
 * are declared as features in their extension manifest. It is only intended to
 * be used by integrators writing IDE support for JSR198.
 */
public class FeatureRegistry extends Service
{

  private Map _features;
  
  /**
   * Gets the feature corresponding to the specified extension.
   * 
   * @param extension the extension to get the feature for.
   * @return The feature for the specified extension, or <tt>null</tt> if
   *    no feature exists for that extension.
   */
  public Feature getFeature( Extension extension )
  {  
    if ( _features == null )
    {
      return null;
    }
    return (Feature) _features.get( extension.getID() );
  }
  
  protected void initialize()
  {
    FeatureHook featureHook = (FeatureHook) 
      ExtensionRegistry.getExtensionRegistry().getHook( FeatureHook.ELEMENT );
      
    _features = featureHook.getFeatures();
  }
  
  public static FeatureRegistry getFeatureRegistry()
  {
    try
    {
      return (FeatureRegistry) getService( FeatureRegistry.class );
    }
    catch ( ProviderNotFoundException nse )
    {
      nse.printStackTrace();
      throw new IllegalStateException( "No feature registry" );
    }
  }
}
