/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension;

/**
 * Visitor for handling elements of type xs:boolean. Subclasses provide an 
 * implementation of {@link #booleanValue( ElementContext, boolean )}, which is
 * called when a boolean value is retrieved for the element.
 */
public abstract class BooleanVisitor extends ElementVisitor
{
  public final void start( ElementStartContext start )
  {
    
  }
  
  public final void end( ElementEndContext end )
  {
    String value = end.getText().trim();
    // Not using Boolean.valueOf(), because the valid values are "true" or
    // "false" only. Boolean.valueOf( "random" ) will return false.
    
    // I know this code looks cookie, but we want to catch unintentional typos
    // in the manifest like "trur" etc.
    boolean result = false;
    if ( "true".equalsIgnoreCase( value ) )
    {
      result = true;
    }
    else if ( "false".equalsIgnoreCase( value ) )
    {
      result = false;
    }
    else
    {
      end.getLogger().severe( "Must be 'true' or 'false'." );
      return;
    }
    
    booleanValue( end, result );
  }
  
  /**
   * Called when the visitor encounters a boolean value.
   * 
   * @param context the xml parsing context.
   * @param value the boolean value.
   */
  protected abstract void booleanValue( ElementContext context, boolean value );
  
}
