/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.editor.spi;

/**
 * Display information for an editor class.
 */
public final class DisplayInfo 
{
  private final String _name;
  
  public DisplayInfo( String name )
  {
    _name = name;
  }
  
  /**
   * Get the name of this editor type as it should be displayed to the user.
   * 
   * @return the name of this editor type.
   */
  public String getName()
  {
    return _name;
  }
  
  public String toString()
  {
    return _name;
  }
}
